/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.spea2;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.Spea2Fitness;

public class SPEA2
extends Algorithm {
    public static final int TOURNAMENTS_ROUNDS = 1;

    public SPEA2(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int archiveSize = (Integer)this.getInputParameter("archiveSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        SolutionSet solutionSet = new SolutionSet(populationSize);
        SolutionSet archive = new SolutionSet(archiveSize);
        int evaluations = 0;
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            solutionSet.add(newSolution);
        }
        while (evaluations < maxEvaluations) {
            SolutionSet union = solutionSet.union(archive);
            Spea2Fitness spea = new Spea2Fitness(union);
            spea.fitnessAssign();
            archive = spea.environmentalSelection(archiveSize);
            SolutionSet offSpringSolutionSet = new SolutionSet(populationSize);
            Solution[] parents = new Solution[2];
            while (offSpringSolutionSet.size() < populationSize) {
                int j = 0;
                do {
                    parents[0] = (Solution)selectionOperator.execute(archive);
                } while (++j < 1);
                int k = 0;
                do {
                    parents[1] = (Solution)selectionOperator.execute(archive);
                } while (++k < 1);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                offSpringSolutionSet.add(offSpring[0]);
                ++evaluations;
            }
            solutionSet = offSpringSolutionSet;
        }
        Ranking ranking = new Ranking(archive);
        return ranking.getSubfront(0);
    }
}

