/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.crossover;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.variable.Binary;
import jmetal.operators.crossover.Crossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class HUXCrossover
extends Crossover {
    private static final List VALID_TYPES = Arrays.asList(BinarySolutionType.class, BinaryRealSolutionType.class);
    private Double probability_ = null;

    public HUXCrossover(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.probability_ = (Double)parameters.get("probability");
        }
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) throws JMException {
        Solution[] offSpring = new Solution[]{new Solution(parent1), new Solution(parent2)};
        try {
            if (PseudoRandom.randDouble() < probability) {
                for (int var = 0; var < parent1.getDecisionVariables().length; ++var) {
                    Binary p1 = (Binary)parent1.getDecisionVariables()[var];
                    Binary p2 = (Binary)parent2.getDecisionVariables()[var];
                    for (int bit = 0; bit < p1.getNumberOfBits(); ++bit) {
                        if (p1.bits_.get(bit) == p2.bits_.get(bit) || !(PseudoRandom.randDouble() < 0.5)) continue;
                        ((Binary)offSpring[0].getDecisionVariables()[var]).bits_.set(bit, p2.bits_.get(bit));
                        ((Binary)offSpring[1].getDecisionVariables()[var]).bits_.set(bit, p1.bits_.get(bit));
                    }
                }
                for (int i = 0; i < offSpring[0].getDecisionVariables().length; ++i) {
                    ((Binary)offSpring[0].getDecisionVariables()[i]).decode();
                    ((Binary)offSpring[1].getDecisionVariables()[i]).decode();
                }
            }
        }
        catch (ClassCastException e1) {
            Configuration.logger_.severe("HUXCrossover.doCrossover: Cannot perfom SinglePointCrossover ");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".doCrossover()");
        }
        return offSpring;
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution[] parents = (Solution[])object;
        if (parents.length < 2) {
            Configuration.logger_.severe("HUXCrossover.execute: operator needs two parents");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        if (!VALID_TYPES.contains(parents[0].getType().getClass()) || !VALID_TYPES.contains(parents[1].getType().getClass())) {
            Configuration.logger_.severe("HUXCrossover.execute: the solutions are not of the right type. The type should be 'Binary' of 'BinaryReal', but " + parents[0].getType() + " and " + parents[1].getType() + " are obtained");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        Solution[] offSpring = this.doCrossover(this.probability_, parents[0], parents[1]);
        for (int i = 0; i < offSpring.length; ++i) {
            offSpring[i].setCrowdingDistance(0.0);
            offSpring[i].setRank(0);
        }
        return offSpring;
    }
}

