/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.crossover;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.crossover.Crossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class SBXCrossover
extends Crossover {
    private static final double EPS = 1.0E-14;
    private static final double ETA_C_DEFAULT_ = 20.0;
    private Double crossoverProbability_ = 0.9;
    private double distributionIndex_ = 20.0;
    private static final List VALID_TYPES = Arrays.asList(RealSolutionType.class, ArrayRealSolutionType.class);

    public SBXCrossover(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.crossoverProbability_ = (Double)parameters.get("probability");
        }
        if (parameters.get("distributionIndex") != null) {
            this.distributionIndex_ = (Double)parameters.get("distributionIndex");
        }
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) throws JMException {
        Solution[] offSpring = new Solution[]{new Solution(parent1), new Solution(parent2)};
        XReal x1 = new XReal(parent1);
        XReal x2 = new XReal(parent2);
        XReal offs1 = new XReal(offSpring[0]);
        XReal offs2 = new XReal(offSpring[1]);
        int numberOfVariables = x1.getNumberOfDecisionVariables();
        if (PseudoRandom.randDouble() <= probability) {
            for (int i = 0; i < numberOfVariables; ++i) {
                double valueX1 = x1.getValue(i);
                double valueX2 = x2.getValue(i);
                if (PseudoRandom.randDouble() <= 0.5) {
                    if (Math.abs(valueX1 - valueX2) > 1.0E-14) {
                        double y2;
                        double y1;
                        if (valueX1 < valueX2) {
                            y1 = valueX1;
                            y2 = valueX2;
                        } else {
                            y1 = valueX2;
                            y2 = valueX1;
                        }
                        double yL = x1.getLowerBound(i);
                        double yu = x1.getUpperBound(i);
                        double rand = PseudoRandom.randDouble();
                        double beta = 1.0 + 2.0 * (y1 - yL) / (y2 - y1);
                        double alpha = 2.0 - Math.pow(beta, -(this.distributionIndex_ + 1.0));
                        double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.distributionIndex_ + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.distributionIndex_ + 1.0));
                        double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
                        beta = 1.0 + 2.0 * (yu - y2) / (y2 - y1);
                        alpha = 2.0 - Math.pow(beta, -(this.distributionIndex_ + 1.0));
                        betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.distributionIndex_ + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.distributionIndex_ + 1.0));
                        double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
                        if (c1 < yL) {
                            c1 = yL;
                        }
                        if (c2 < yL) {
                            c2 = yL;
                        }
                        if (c1 > yu) {
                            c1 = yu;
                        }
                        if (c2 > yu) {
                            c2 = yu;
                        }
                        if (PseudoRandom.randDouble() <= 0.5) {
                            offs1.setValue(i, c2);
                            offs2.setValue(i, c1);
                            continue;
                        }
                        offs1.setValue(i, c1);
                        offs2.setValue(i, c2);
                        continue;
                    }
                    offs1.setValue(i, valueX1);
                    offs2.setValue(i, valueX2);
                    continue;
                }
                offs1.setValue(i, valueX2);
                offs2.setValue(i, valueX1);
            }
        }
        return offSpring;
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution[] parents = (Solution[])object;
        if (parents.length != 2) {
            Configuration.logger_.severe("SBXCrossover.execute: operator needs two parents");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        if (!VALID_TYPES.contains(parents[0].getType().getClass()) || !VALID_TYPES.contains(parents[1].getType().getClass())) {
            Configuration.logger_.severe("SBXCrossover.execute: the solutions type " + parents[0].getType() + " is not allowed with this operator");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        Solution[] offSpring = this.doCrossover(this.crossoverProbability_, parents[0], parents[1]);
        return offSpring;
    }
}

