/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.mutation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealAndBinarySolutionType;
import jmetal.encodings.variable.Binary;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class PolynomialBitFlipMutation
extends Mutation {
    private static final double ETA_M_DEFAULT_ = 20.0;
    private final double eta_m_ = 20.0;
    private Double realMutationProbability_ = null;
    private Double binaryMutationProbability_ = null;
    private double distributionIndex_ = 20.0;
    private static final List VALID_TYPES = Arrays.asList(ArrayRealAndBinarySolutionType.class);

    public PolynomialBitFlipMutation(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("realMutationProbability") != null) {
            this.realMutationProbability_ = (Double)parameters.get("realMutationProbability");
        }
        if (parameters.get("binaryMutationProbability") != null) {
            this.binaryMutationProbability_ = (Double)parameters.get("binaryMutationProbability");
        }
        if (parameters.get("distributionIndex") != null) {
            this.distributionIndex_ = (Double)parameters.get("distributionIndex");
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("PolynomialBitFlipMutation.execute: the solution type " + solution.getType() + " is not allowed with this operator");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        this.doMutation(this.realMutationProbability_, this.binaryMutationProbability_, solution);
        return solution;
    }

    public void doMutation(Double realProbability, Double binaryProbability, Solution solution) throws JMException {
        XReal x = new XReal(solution);
        Binary binaryVariable = (Binary)solution.getDecisionVariables()[1];
        for (int var = 0; var < x.size(); ++var) {
            double deltaq;
            double val;
            double xy;
            if (!(PseudoRandom.randDouble() <= realProbability)) continue;
            double y = x.getValue(var);
            double yl = x.getLowerBound(var);
            double yu = x.getUpperBound(var);
            double delta1 = (y - yl) / (yu - yl);
            double delta2 = (yu - y) / (yu - yl);
            double rnd = PseudoRandom.randDouble();
            double mut_pow = 0.047619047619047616;
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex_ + 1.0);
                deltaq = Math.pow(val, mut_pow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex_ + 1.0);
                deltaq = 1.0 - Math.pow(val, mut_pow);
            }
            y += deltaq * (yu - yl);
            if (y < yl) {
                y = yl;
            }
            if (y > yu) {
                y = yu;
            }
            x.setValue(var, y);
        }
        for (int i = 0; i < binaryVariable.getNumberOfBits(); ++i) {
            if (!(PseudoRandom.randDouble() < binaryProbability)) continue;
            binaryVariable.bits_.flip(i);
        }
    }
}

