/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.selection;

import java.util.Comparator;
import java.util.HashMap;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.Selection;
import jmetal.util.PseudoRandom;
import jmetal.util.comparators.DominanceComparator;

public class BinaryTournament
extends Selection {
    private Comparator comparator_;

    public BinaryTournament(HashMap<String, Object> parameters) {
        super(parameters);
        this.comparator_ = parameters != null && parameters.get("comparator") != null ? (Comparator)parameters.get("comparator") : new DominanceComparator();
    }

    @Override
    public Object execute(Object object) {
        int flag;
        SolutionSet solutionSet = (SolutionSet)object;
        Solution solution1 = solutionSet.get(PseudoRandom.randInt(0, solutionSet.size() - 1));
        Solution solution2 = solutionSet.get(PseudoRandom.randInt(0, solutionSet.size() - 1));
        if (solutionSet.size() >= 2) {
            while (solution1 == solution2) {
                solution2 = solutionSet.get(PseudoRandom.randInt(0, solutionSet.size() - 1));
            }
        }
        if ((flag = this.comparator_.compare(solution1, solution2)) == -1) {
            return solution1;
        }
        if (flag == 1) {
            return solution2;
        }
        if (PseudoRandom.randDouble() < 0.5) {
            return solution1;
        }
        return solution2;
    }
}

