/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.selection;

import java.util.Comparator;
import java.util.HashMap;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.Selection;
import jmetal.util.Configuration;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingComparator;

public class RankingAndCrowdingSelection
extends Selection {
    private Problem problem_ = null;
    private static final Comparator crowdingComparator_ = new CrowdingComparator();
    private static final Distance distance_ = new Distance();

    public RankingAndCrowdingSelection(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("problem") != null) {
            this.problem_ = (Problem)parameters.get("problem");
        }
        if (this.problem_ == null) {
            Configuration.logger_.severe("RankingAndCrowdingSelection.execute: problem not specified");
            Class<String> cls = String.class;
            String string = cls.getName();
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        int k;
        SolutionSet population = (SolutionSet)object;
        int populationSize = (Integer)this.parameters_.get("populationSize");
        SolutionSet result = new SolutionSet(populationSize);
        Ranking ranking = new Ranking(population);
        int remain = populationSize;
        int index = 0;
        SolutionSet front = null;
        population.clear();
        front = ranking.getSubfront(index);
        while (remain > 0 && remain >= front.size()) {
            distance_.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
            for (k = 0; k < front.size(); ++k) {
                result.add(front.get(k));
            }
            ++index;
            if ((remain -= front.size()) <= 0) continue;
            front = ranking.getSubfront(index);
        }
        if (remain > 0) {
            distance_.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
            front.sort(crowdingComparator_);
            for (k = 0; k < remain; ++k) {
                result.add(front.get(k));
            }
            remain = 0;
        }
        return result;
    }
}

