/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.DTLZ;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class DTLZ6
extends Problem {
    public DTLZ6(String solutionType) throws ClassNotFoundException {
        this(solutionType, 12, 3);
    }

    public DTLZ6(String solutionType, Integer numberOfVariables, Integer numberOfObjectives) {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = numberOfObjectives;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "DTLZ6";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = 1.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int i;
        Variable[] gen = solution.getDecisionVariables();
        double[] x = new double[this.numberOfVariables_];
        double[] f = new double[this.numberOfObjectives_];
        double[] theta = new double[this.numberOfObjectives_ - 1];
        int k = this.numberOfVariables_ - this.numberOfObjectives_ + 1;
        for (int i2 = 0; i2 < this.numberOfVariables_; ++i2) {
            x[i2] = gen[i2].getValue();
        }
        double g = 0.0;
        for (int i3 = this.numberOfVariables_ - k; i3 < this.numberOfVariables_; ++i3) {
            g += Math.pow(x[i3], 0.1);
        }
        double t = Math.PI / (4.0 * (1.0 + g));
        theta[0] = x[0] * Math.PI / 2.0;
        for (i = 1; i < this.numberOfObjectives_ - 1; ++i) {
            theta[i] = t * (1.0 + 2.0 * g * x[i]);
        }
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            f[i] = 1.0 + g;
        }
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            for (int j = 0; j < this.numberOfObjectives_ - (i + 1); ++j) {
                int n = i;
                f[n] = f[n] * Math.cos(theta[j]);
            }
            if (i == 0) continue;
            int aux = this.numberOfObjectives_ - (i + 1);
            int n = i;
            f[n] = f[n] * Math.sin(theta[aux]);
        }
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

