/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;
import jmetal.util.wrapper.XReal;

public class Kursawe
extends Problem {
    public Kursawe(String solutionType) throws ClassNotFoundException {
        this(solutionType, 3);
    }

    public Kursawe(String solutionType, Integer numberOfVariables) {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Kursawe";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            this.lowerLimit_[i] = -5.0;
            this.upperLimit_[i] = 5.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else if (solutionType.compareTo("ArrayReal") == 0) {
            this.solutionType_ = new ArrayRealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int var;
        XReal vars = new XReal(solution);
        double[] fx = new double[2];
        double[] x = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = vars.getValue(i);
        }
        fx[0] = 0.0;
        for (var = 0; var < this.numberOfVariables_ - 1; ++var) {
            double xi = x[var] * x[var];
            double xj = x[var + 1] * x[var + 1];
            double aux = -0.2 * Math.sqrt(xi + xj);
            fx[0] = fx[0] + -10.0 * Math.exp(aux);
        }
        fx[1] = 0.0;
        for (var = 0; var < this.numberOfVariables_; ++var) {
            fx[1] = fx[1] + (Math.pow(Math.abs(x[var]), 0.8) + 5.0 * Math.sin(Math.pow(x[var], 3.0)));
        }
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }
}

