/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.variable.Binary;

public class OneZeroMax
extends Problem {
    public OneZeroMax(String solutionType) throws ClassNotFoundException {
        this(solutionType, 512);
    }

    public OneZeroMax(String solutionType, Integer numberOfBits) {
        this.numberOfVariables_ = 1;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "OneZeroMax";
        this.solutionType_ = new BinarySolutionType(this);
        this.length_ = new int[this.numberOfVariables_];
        this.length_[0] = numberOfBits;
        if (solutionType.compareTo("Binary") == 0) {
            this.solutionType_ = new BinarySolutionType(this);
        } else {
            System.out.println("OneZeroMax: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) {
        Binary variable = (Binary)solution.getDecisionVariables()[0];
        int counterOnes = 0;
        int counterZeroes = 0;
        for (int i = 0; i < variable.getNumberOfBits(); ++i) {
            if (variable.bits_.get(i)) {
                ++counterOnes;
                continue;
            }
            ++counterZeroes;
        }
        solution.setObjective(0, -1.0 * (double)counterOnes);
        solution.setObjective(1, -1.0 * (double)counterZeroes);
    }
}

