/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Poloni
extends Problem {
    public Poloni(String solutionType) {
        this.numberOfVariables_ = 2;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Poloni";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -Math.PI;
            this.upperLimit_[var] = Math.PI;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        double A1 = 0.5 * Math.sin(1.0) - 2.0 * Math.cos(1.0) + Math.sin(2.0) - 1.5 * Math.cos(2.0);
        double A2 = 1.5 * Math.sin(1.0) - Math.cos(1.0) + 2.0 * Math.sin(2.0) - 0.5 * Math.cos(2.0);
        Variable[] decisionVariables = solution.getDecisionVariables();
        double[] x = new double[this.numberOfVariables_];
        double[] f = new double[this.numberOfObjectives_];
        x[0] = decisionVariables[0].getValue();
        x[1] = decisionVariables[1].getValue();
        double B1 = 0.5 * Math.sin(x[0]) - 2.0 * Math.cos(x[0]) + Math.sin(x[1]) - 1.5 * Math.cos(x[1]);
        double B2 = 1.5 * Math.sin(x[0]) - Math.cos(x[0]) + 2.0 * Math.sin(x[1]) - 0.5 * Math.cos(x[1]);
        f[0] = -(1.0 + Math.pow(A1 - B1, 2.0) + Math.pow(A2 - B2, 2.0));
        f[1] = -(Math.pow(x[0] + 3.0, 2.0) + Math.pow(x[1] + 1.0, 2.0));
        solution.setObjective(0, -1.0 * f[0]);
        solution.setObjective(1, -1.0 * f[1]);
    }
}

