/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import java.lang.reflect.Constructor;
import jmetal.core.Problem;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class ProblemFactory {
    public Problem getProblem(String name, Object[] params) throws JMException {
        String base = "jmetal.problems.";
        if (name.equals("TSP") || name.equals("OneMax")) {
            base = base + "singleObjective.";
        } else if (name.equals("mQAP")) {
            base = base + "mqap.";
        } else if (name.substring(0, name.length() - 1).equalsIgnoreCase("DTLZ")) {
            base = base + "DTLZ.";
        } else if (name.substring(0, name.length() - 1).equalsIgnoreCase("WFG")) {
            base = base + "WFG.";
        } else if (name.substring(0, name.length() - 1).equalsIgnoreCase("UF")) {
            base = base + "cec2009Competition.";
        } else if (name.substring(0, name.length() - 2).equalsIgnoreCase("UF")) {
            base = base + "cec2009Competition.";
        } else if (name.substring(0, name.length() - 1).equalsIgnoreCase("ZDT")) {
            base = base + "ZDT.";
        } else if (name.substring(0, name.length() - 3).equalsIgnoreCase("ZZJ07")) {
            base = base + "ZZJ07.";
        } else if (name.substring(0, name.length() - 3).equalsIgnoreCase("LZ09")) {
            base = base + "LZ09.";
        } else if (name.substring(0, name.length() - 4).equalsIgnoreCase("ZZJ07")) {
            base = base + "ZZJ07.";
        } else if (name.substring(0, name.length() - 3).equalsIgnoreCase("LZ06")) {
            base = base + "LZ06.";
        }
        try {
            int i;
            Class<?> problemClass = Class.forName(base + name);
            Constructor<?>[] constructors = problemClass.getConstructors();
            for (i = 0; i < constructors.length && constructors[i].getParameterTypes().length != params.length; ++i) {
            }
            Problem problem = (Problem)constructors[i].newInstance(params);
            return problem;
        }
        catch (Exception e) {
            Configuration.logger_.severe("ProblemFactory.getProblem: Problem '" + name + "' does not exist. " + "Please, check the problem names in jmetal/problems");
            e.printStackTrace();
            throw new JMException("Exception in " + name + ".getProblem()");
        }
    }
}

