/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Schaffer
extends Problem {
    public Schaffer(String solutionType) {
        this.numberOfVariables_ = 1;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Schaffer";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = -100000.0;
        this.upperLimit_[0] = 100000.0;
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] variable = solution.getDecisionVariables();
        double[] f = new double[this.numberOfObjectives_];
        f[0] = variable[0].getValue() * variable[0].getValue();
        f[1] = (variable[0].getValue() - 2.0) * (variable[0].getValue() - 2.0);
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }
}

