/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Viennet4
extends Problem {
    public Viennet4(String solutionType) {
        this.numberOfVariables_ = 2;
        this.numberOfObjectives_ = 3;
        this.numberOfConstraints_ = 3;
        this.problemName_ = "Viennet4";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -4.0;
            this.upperLimit_[var] = 4.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int i;
        double[] x = new double[this.numberOfVariables_];
        double[] f = new double[this.numberOfObjectives_];
        for (i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = solution.getDecisionVariables()[i].getValue();
        }
        f[0] = (x[0] - 2.0) * (x[0] - 2.0) / 2.0 + (x[1] + 1.0) * (x[1] + 1.0) / 13.0 + 3.0;
        f[1] = (x[0] + x[1] - 3.0) * (x[0] + x[1] - 3.0) / 175.0 + (2.0 * x[1] - x[0]) * (2.0 * x[1] - x[0]) / 17.0 - 13.0;
        f[2] = (3.0 * x[0] - 2.0 * x[1] + 4.0) * (3.0 * x[0] - 2.0 * x[1] + 4.0) / 8.0 + (x[0] - x[1] + 1.0) * (x[0] - x[1] + 1.0) / 27.0 + 15.0;
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }

    @Override
    public void evaluateConstraints(Solution solution) throws JMException {
        double[] constraint = new double[this.numberOfConstraints_];
        double x1 = solution.getDecisionVariables()[0].getValue();
        double x2 = solution.getDecisionVariables()[1].getValue();
        constraint[0] = -x2 - 4.0 * x1 + 4.0;
        constraint[1] = x1 + 1.0;
        constraint[2] = x2 - x1 + 2.0;
        int number = 0;
        double total = 0.0;
        for (int i = 0; i < this.numberOfConstraints_; ++i) {
            if (!(constraint[i] < 0.0)) continue;
            ++number;
            total += constraint[i];
        }
        solution.setOverallConstraintViolation(total);
        solution.setNumberOfViolatedConstraint(number);
    }
}

