/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.WFG;

public class Shapes {
    public float linear(float[] x, int m) {
        float result = 1.0f;
        int M = x.length;
        for (int i = 1; i <= M - m; ++i) {
            result *= x[i - 1];
        }
        if (m != 1) {
            result *= 1.0f - x[M - m];
        }
        return result;
    }

    public float convex(float[] x, int m) {
        float result = 1.0f;
        int M = x.length;
        for (int i = 1; i <= M - m; ++i) {
            result = (float)((double)result * (1.0 - Math.cos((double)x[i - 1] * Math.PI * 0.5)));
        }
        if (m != 1) {
            result = (float)((double)result * (1.0 - Math.sin((double)x[M - m] * Math.PI * 0.5)));
        }
        return result;
    }

    public float concave(float[] x, int m) {
        float result = 1.0f;
        int M = x.length;
        for (int i = 1; i <= M - m; ++i) {
            result = (float)((double)result * Math.sin((double)x[i - 1] * Math.PI * 0.5));
        }
        if (m != 1) {
            result = (float)((double)result * Math.cos((double)x[M - m] * Math.PI * 0.5));
        }
        return result;
    }

    public float mixed(float[] x, int A, float alpha) {
        float tmp = (float)Math.cos(2.0f * (float)A * (float)Math.PI * x[0] + 1.5707964f);
        tmp = (float)((double)tmp / (2.0 * (double)A * Math.PI));
        return (float)Math.pow(1.0f - x[0] - tmp, alpha);
    }

    public float disc(float[] x, int A, float alpha, float beta) {
        float tmp = (float)Math.cos((double)A * Math.pow(x[0], beta) * Math.PI);
        return 1.0f - (float)Math.pow(x[0], alpha) * (float)Math.pow(tmp, 2.0);
    }
}

