/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.WFG;

import jmetal.util.Configuration;
import jmetal.util.JMException;

public class Transformations {
    private static final float epsilon = 1.0E-10f;

    public float b_poly(float y, float alpha) throws JMException {
        if (!(alpha > 0.0f)) {
            Configuration.logger_.severe("WFG.Transformations.b_poly: Param alpha must be > 0");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".b_poly()");
        }
        return this.correct_to_01((float)StrictMath.pow(y, alpha));
    }

    public float b_flat(float y, float A, float B, float C) {
        float tmp1 = Math.min(0.0f, (float)Math.floor(y - B)) * A * (B - y) / B;
        float tmp2 = Math.min(0.0f, (float)Math.floor(C - y)) * (1.0f - A) * (y - C) / (1.0f - C);
        return this.correct_to_01(A + tmp1 - tmp2);
    }

    public float s_linear(float y, float A) {
        return this.correct_to_01(Math.abs(y - A) / (float)Math.abs(Math.floor(A - y) + (double)A));
    }

    public float s_decept(float y, float A, float B, float C) {
        float tmp1 = (float)Math.floor(y - A + B) * (1.0f - C + (A - B) / B) / (A - B);
        float tmp2 = (float)Math.floor(A + B - y) * (1.0f - C + (1.0f - A - B) / B) / (1.0f - A - B);
        float tmp = Math.abs(y - A) - B;
        return this.correct_to_01(1.0f + tmp * (tmp1 + tmp2 + 1.0f / B));
    }

    public float s_multi(float y, int A, int B, float C) {
        float tmp1 = (4.0f * (float)A + 2.0f) * (float)Math.PI * (0.5f - Math.abs(y - C) / (2.0f * ((float)Math.floor(C - y) + C)));
        float tmp2 = 4.0f * (float)B * (float)StrictMath.pow(Math.abs(y - C) / (2.0f * ((float)Math.floor(C - y) + C)), 2.0);
        return this.correct_to_01((1.0f + (float)Math.cos(tmp1) + tmp2) / ((float)B + 2.0f));
    }

    public float r_sum(float[] y, float[] w) {
        float tmp1 = 0.0f;
        float tmp2 = 0.0f;
        for (int i = 0; i < y.length; ++i) {
            tmp1 += y[i] * w[i];
            tmp2 += w[i];
        }
        return this.correct_to_01(tmp1 / tmp2);
    }

    public float r_nonsep(float[] y, int A) {
        float tmp = (float)Math.ceil((float)A / 2.0f);
        float denominator = (float)y.length * tmp * (1.0f + 2.0f * (float)A - 2.0f * tmp) / (float)A;
        float numerator = 0.0f;
        for (int j = 0; j < y.length; ++j) {
            numerator += y[j];
            for (int k = 0; k <= A - 2; ++k) {
                numerator += Math.abs(y[j] - y[(j + k + 1) % y.length]);
            }
        }
        return this.correct_to_01(numerator / denominator);
    }

    public float b_param(float y, float u, float A, float B, float C) {
        float v = A - (1.0f - 2.0f * u) * Math.abs((float)Math.floor(0.5f - u) + A);
        float exp = B + (C - B) * v;
        float result = (float)StrictMath.pow(y, exp);
        return this.correct_to_01(result);
    }

    float correct_to_01(float a) {
        float min = 0.0f;
        float max = 1.0f;
        float min_epsilon = min - 1.0E-10f;
        float max_epsilon = max + 1.0E-10f;
        if (a <= min && a >= min_epsilon || a >= min && a <= min_epsilon) {
            return min;
        }
        if (a >= max && a <= max_epsilon || a <= max && a >= max_epsilon) {
            return max;
        }
        return a;
    }
}

