/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.WFG;

import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.problems.WFG.Shapes;
import jmetal.problems.WFG.Transformations;
import jmetal.problems.WFG.WFG;
import jmetal.util.JMException;

public class WFG3
extends WFG {
    public WFG3(String solutionType) throws ClassNotFoundException {
        this(solutionType, 2, 4, 2);
    }

    public WFG3(String solutionType, Integer k, Integer l, Integer M) throws ClassNotFoundException {
        super(solutionType, k, l, M);
        int i;
        this.problemName_ = "WFG3";
        this.S_ = new int[this.M_];
        for (i = 0; i < this.M_; ++i) {
            this.S_[i] = 2 * (i + 1);
        }
        this.A_ = new int[this.M_ - 1];
        this.A_[0] = 1;
        for (i = 1; i < this.M_ - 1; ++i) {
            this.A_[i] = 0;
        }
    }

    @Override
    public float[] evaluate(float[] z) {
        float[] y = this.normalise(z);
        y = this.t1(y, this.k_);
        y = this.t2(y, this.k_);
        y = this.t3(y, this.k_, this.M_);
        float[] result = new float[this.M_];
        float[] x = this.calculate_x(y);
        for (int m = 1; m <= this.M_; ++m) {
            result[m - 1] = (float)this.D_ * x[this.M_ - 1] + (float)this.S_[m - 1] * new Shapes().linear(x, m);
        }
        return result;
    }

    public float[] t1(float[] z, int k) {
        float[] result = new float[z.length];
        System.arraycopy(z, 0, result, 0, k);
        for (int i = k; i < z.length; ++i) {
            result[i] = new Transformations().s_linear(z[i], 0.35f);
        }
        return result;
    }

    public float[] t2(float[] z, int k) {
        float[] result = new float[z.length];
        System.arraycopy(z, 0, result, 0, k);
        int l = z.length - k;
        for (int i = k + 1; i <= k + l / 2; ++i) {
            int head = k + 2 * (i - k) - 1;
            int tail = k + 2 * (i - k);
            float[] subZ = this.subVector(z, head - 1, tail - 1);
            result[i - 1] = new Transformations().r_nonsep(subZ, 2);
        }
        return result;
    }

    public float[] t3(float[] z, int k, int M) {
        float[] subW;
        float[] subZ;
        int tail;
        int head;
        int i;
        float[] result = new float[M];
        float[] w = new float[z.length];
        for (i = 0; i < z.length; ++i) {
            w[i] = 1.0f;
        }
        for (i = 1; i <= M - 1; ++i) {
            head = (i - 1) * k / (M - 1) + 1;
            tail = i * k / (M - 1);
            subZ = this.subVector(z, head - 1, tail - 1);
            subW = this.subVector(w, head - 1, tail - 1);
            result[i - 1] = new Transformations().r_sum(subZ, subW);
        }
        int l = z.length - k;
        head = k + 1;
        tail = k + l / 2;
        subZ = this.subVector(z, head - 1, tail - 1);
        subW = this.subVector(w, head - 1, tail - 1);
        result[M - 1] = new Transformations().r_sum(subZ, subW);
        return result;
    }

    @Override
    public final void evaluate(Solution solution) throws JMException {
        float[] variables = new float[this.getNumberOfVariables()];
        Variable[] dv = solution.getDecisionVariables();
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            variables[i] = (float)dv[i].getValue();
        }
        float[] sol = this.evaluate(variables);
        for (int i = 0; i < sol.length; ++i) {
            solution.setObjective(i, sol[i]);
        }
    }
}

