/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Water
extends Problem {
    public static final double[] LOWERLIMIT = new double[]{0.01, 0.01, 0.01};
    public static final double[] UPPERLIMIT = new double[]{0.45, 0.1, 0.1};

    public Water(String solutionType) {
        this.numberOfVariables_ = 3;
        this.numberOfObjectives_ = 5;
        this.numberOfConstraints_ = 7;
        this.problemName_ = "Water";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = LOWERLIMIT[var];
            this.upperLimit_[var] = UPPERLIMIT[var];
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        double[] x = new double[3];
        double[] f = new double[5];
        x[0] = solution.getDecisionVariables()[0].getValue();
        x[1] = solution.getDecisionVariables()[1].getValue();
        x[2] = solution.getDecisionVariables()[2].getValue();
        f[0] = 106780.37 * (x[1] + x[2]) + 61704.67;
        f[1] = 3000.0 * x[0];
        f[2] = 6.997473E8 * x[1] / Math.pow(137.34, 0.65);
        f[3] = 572250.0 * Math.exp(-39.75 * x[1] + 9.9 * x[2] + 2.74);
        f[4] = 25.0 * (1.39 / (x[0] * x[1]) + 4940.0 * x[2] - 80.0);
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
        solution.setObjective(2, f[2]);
        solution.setObjective(3, f[3]);
        solution.setObjective(4, f[4]);
    }

    @Override
    public void evaluateConstraints(Solution solution) throws JMException {
        double[] constraint = new double[7];
        double[] x = new double[]{solution.getDecisionVariables()[0].getValue(), solution.getDecisionVariables()[1].getValue(), solution.getDecisionVariables()[2].getValue()};
        constraint[0] = 1.0 - (0.00139 / (x[0] * x[1]) + 4.94 * x[2] - 0.08);
        constraint[1] = 1.0 - (3.06E-4 / (x[0] * x[1]) + 1.082 * x[2] - 0.0986);
        constraint[2] = 50000.0 - (12.307 / (x[0] * x[1]) + 49408.24 * x[2] + 4051.02);
        constraint[3] = 16000.0 - (2.098 / (x[0] * x[1]) + 8046.33 * x[2] - 696.71);
        constraint[4] = 10000.0 - (2.138 / (x[0] * x[1]) + 7883.39 * x[2] - 705.04);
        constraint[5] = 2000.0 - (0.417 * x[0] * x[1] + 1721.26 * x[2] - 136.54);
        constraint[6] = 550.0 - (0.164 / (x[0] * x[1]) + 631.13 * x[2] - 54.48);
        double total = 0.0;
        int number = 0;
        for (int i = 0; i < this.numberOfConstraints_; ++i) {
            if (!(constraint[i] < 0.0)) continue;
            total += constraint[i];
            ++number;
        }
        solution.setOverallConstraintViolation(total);
        solution.setNumberOfViolatedConstraint(number);
    }
}

