/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.ZDT;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.variable.Binary;

public class ZDT5
extends Problem {
    public ZDT5(String solutionType) throws ClassNotFoundException {
        this(solutionType, 11);
    }

    public ZDT5(String solutionType, Integer numberOfVariables) {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "ZDT5";
        this.length_ = new int[this.numberOfVariables_];
        this.length_[0] = 30;
        for (int var = 1; var < this.numberOfVariables_; ++var) {
            this.length_[var] = 5;
        }
        this.solutionType_ = new BinarySolutionType(this);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] f = new double[this.numberOfObjectives_];
        f[0] = 1.0 + this.u((Binary)solution.getDecisionVariables()[0]);
        double g = this.evalG(solution.getDecisionVariables());
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    public double evalG(Variable[] decisionVariables) {
        double res = 0.0;
        for (int var = 1; var < this.numberOfVariables_; ++var) {
            res += this.evalV(this.u((Binary)decisionVariables[var]));
        }
        return res;
    }

    public double evalV(double value) {
        if (value < 5.0) {
            return 2.0 + value;
        }
        return 1.0;
    }

    public double evalH(double f, double g) {
        return 1.0 / f;
    }

    private double u(Binary variable) {
        return variable.bits_.cardinality();
    }
}

