/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.cec2009Competition;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class UF1
extends Problem {
    public UF1(String solutionType) throws ClassNotFoundException {
        this(solutionType, 30);
    }

    public UF1(String solutionType, Integer numberOfVariables) {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "CEC2009_UF1";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = 0.0;
        this.upperLimit_[0] = 1.0;
        for (int var = 1; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -1.0;
            this.upperLimit_[var] = 1.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] decisionVariables = solution.getDecisionVariables();
        double[] x = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = decisionVariables[i].getValue();
        }
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 2; j <= this.numberOfVariables_; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)this.numberOfVariables_);
            yj *= yj;
            if (j % 2 == 0) {
                sum2 += yj;
                ++count2;
                continue;
            }
            sum1 += yj;
            ++count1;
        }
        solution.setObjective(0, x[0] + 2.0 * sum1 / (double)count1);
        solution.setObjective(1, 1.0 - Math.sqrt(x[0]) + 2.0 * sum2 / (double)count2);
    }
}

