/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.mqap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadInstance {
    private String fileName_;
    private int[][] a_matrix;
    private int[][][] b_matrixs;
    private int facilities_ = -1;
    private int objectives_ = -1;
    private String singleObjectiveFirstLine_ = "";

    public ReadInstance(String name) {
        this.fileName_ = name;
    }

    public void loadInstance() {
        try {
            int i;
            File archivo = new File(this.fileName_);
            FileReader fr = null;
            BufferedReader br = null;
            fr = new FileReader(archivo);
            br = new BufferedReader(fr);
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line);
            String newLine = "";
            while (st.hasMoreTokens()) {
                String aux;
                String newToken = st.nextToken();
                if (newToken.toUpperCase().contains("FACILITIES")) {
                    newLine = newLine + newToken + " ";
                    aux = "";
                    do {
                        try {
                            aux = st.nextToken();
                            this.facilities_ = new Integer(aux);
                            newLine = newLine + aux + " ";
                        }
                        catch (NumberFormatException ne) {
                            newLine = newLine + aux + " ";
                        }
                    } while (this.facilities_ < 0);
                    continue;
                }
                if (newToken.toUpperCase().contains("OBJECTIVES")) {
                    newLine = newLine + newToken + " ";
                    aux = "";
                    do {
                        try {
                            aux = st.nextToken();
                            this.objectives_ = new Integer(aux);
                            newLine = newLine + "1 ";
                        }
                        catch (NumberFormatException ne) {
                            newLine = newLine + aux + " ";
                        }
                    } while (this.objectives_ < 0);
                    continue;
                }
                newLine = newLine + newToken + " ";
            }
            this.singleObjectiveFirstLine_ = newLine;
            this.a_matrix = new int[this.facilities_][this.facilities_];
            line = br.readLine();
            while (line.isEmpty()) {
                line = br.readLine();
            }
            for (i = 0; i < this.facilities_; ++i) {
                st = new StringTokenizer(line);
                for (int j = 0; j < this.facilities_; ++j) {
                    this.a_matrix[i][j] = new Integer(st.nextToken());
                }
                line = br.readLine();
            }
            this.b_matrixs = new int[this.objectives_][this.facilities_][this.facilities_];
            for (int k = 0; k < this.objectives_; ++k) {
                while (line.isEmpty()) {
                    line = br.readLine();
                }
                for (int i2 = 0; i2 < this.facilities_; ++i2) {
                    st = new StringTokenizer(line);
                    for (int j = 0; j < this.facilities_; ++j) {
                        this.b_matrixs[k][i2][j] = new Integer(st.nextToken());
                    }
                    line = br.readLine();
                }
            }
            for (i = 0; i < this.facilities_; ++i) {
                for (int j = 0; j < this.facilities_; ++j) {
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ReadInstance.class.getName()).log(Level.SEVERE, "The file doesn't exist", ex);
        }
        catch (IOException ex2) {
            Logger.getLogger(ReadInstance.class.getName()).log(Level.SEVERE, "Error reading from file", ex2);
        }
    }

    public void createSingleObjectiveInstance(int[] weights) {
        if (weights.length != this.objectives_) {
            Logger.getLogger(ReadInstance.class.getName()).log(Level.SEVERE, "The number of weights and number of objectives don't match");
        }
        try {
            int j;
            String line;
            int i;
            String name = "";
            for (int k = 0; k < this.objectives_; ++k) {
                name = name + "_" + weights[k];
            }
            System.out.println(name);
            System.out.println(this.fileName_ + name);
            FileOutputStream fos = new FileOutputStream(this.fileName_ + name);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(this.facilities_ + "");
            bw.newLine();
            bw.newLine();
            for (i = 0; i < this.facilities_; ++i) {
                line = "";
                for (j = 0; j < this.facilities_; ++j) {
                    line = line + this.a_matrix[i][j] + " ";
                }
                bw.write(line);
                bw.newLine();
            }
            bw.newLine();
            for (i = 0; i < this.facilities_; ++i) {
                line = "";
                for (j = 0; j < this.facilities_; ++j) {
                    int aggregateValue = 0;
                    for (int k = 0; k < this.objectives_; ++k) {
                        aggregateValue += weights[k] * this.b_matrixs[k][i][j];
                    }
                    line = line + aggregateValue + " ";
                }
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ReadInstance.class.getName()).log(Level.SEVERE, "The file cannot be created", ex);
        }
        catch (IOException ex1) {
            Logger.getLogger(ReadInstance.class.getName()).log(Level.SEVERE, "Error writting in the file", ex1);
        }
    }

    int[][] get_a_Matrix() {
        return this.a_matrix;
    }

    int[][][] get_b_Matrixs() {
        return this.b_matrixs;
    }

    int getNumberOfObjectives() {
        return this.objectives_;
    }

    int getNumberOfFacilities() {
        return this.facilities_;
    }

    public static void main(String[] args) {
        ReadInstance ri = new ReadInstance(args[0]);
        ri.loadInstance();
        if (args.length > 1 && args[1].toUpperCase().contains("Y")) {
            if (ri.getNumberOfObjectives() > 3) {
                Logger.getLogger(ReadInstance.class.getName()).log(Level.SEVERE, "Aggregative approache with more than 2 objectives not implemented yet");
            } else if (ri.getNumberOfObjectives() == 3) {
                System.out.println("3 objetivos");
                try {
                    String dataFile = "/home/juan/Dropbox/workingOn/qap/W3D_100.dat";
                    FileInputStream fis = new FileInputStream(dataFile);
                    InputStreamReader isr = new InputStreamReader(fis);
                    BufferedReader br = new BufferedReader(isr);
                    int numberOfObjectives = 0;
                    String aux = br.readLine();
                    while (aux != null) {
                        StringTokenizer st = new StringTokenizer(aux);
                        numberOfObjectives = st.countTokens();
                        int[] weight = new int[numberOfObjectives];
                        for (int k = 0; k < numberOfObjectives; ++k) {
                            weight[k] = new Integer(st.nextToken());
                            System.out.println(weight[k]);
                        }
                        ri.createSingleObjectiveInstance(weight);
                        aux = br.readLine();
                    }
                    br.close();
                }
                catch (Exception e) {
                    System.out.println("initUniformWeight: failed when reading for file containing the weight");
                    e.printStackTrace();
                }
            } else {
                int a = 100;
                int b = 0;
                while (a >= 0) {
                    int[] weight = new int[]{a--, b};
                    ri.createSingleObjectiveInstance(weight);
                    b = 100 - a;
                }
            }
        }
    }
}

