/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.mqap;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.variable.Permutation;
import jmetal.problems.mqap.ReadInstance;
import jmetal.util.JMException;

public class mQAP
extends Problem {
    int[][] a_matrix;
    int[][][] b_matrixs;

    public mQAP(String solutionType) {
        this(solutionType, "KC10-2fl-2rl.dat");
    }

    public mQAP(String solutionType, String fileName) {
        int var;
        ReadInstance ri = new ReadInstance(fileName);
        ri.loadInstance();
        this.numberOfVariables_ = 1;
        this.numberOfObjectives_ = ri.getNumberOfObjectives();
        this.numberOfConstraints_ = 0;
        this.problemName_ = "mQAP";
        this.a_matrix = ri.get_a_Matrix();
        this.b_matrixs = ri.get_b_Matrixs();
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = ri.getNumberOfFacilities() - 1;
        }
        this.length_ = new int[this.numberOfVariables_];
        for (var = 0; var < this.numberOfVariables_; ++var) {
            this.length_[var] = ri.getNumberOfFacilities();
        }
        if (solutionType.compareTo("Permutation") == 0) {
            this.solutionType_ = new PermutationSolutionType(this);
        } else {
            try {
                throw new JMException("SolutionType must be Permutation");
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int[] permutation = ((Permutation)solution.getDecisionVariables()[0]).vector_;
        for (int k = 0; k < this.numberOfObjectives_; ++k) {
            double aux = 0.0;
            for (int i = 0; i < this.a_matrix.length; ++i) {
                for (int j = 0; j < this.a_matrix[i].length; ++j) {
                    aux += (double)(this.a_matrix[i][j] * this.b_matrixs[k][permutation[i]][permutation[j]]);
                }
            }
            solution.setObjective(k, aux);
        }
    }
}

