/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.singleObjective;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.variable.Permutation;
import jmetal.util.JMException;

public class TSP
extends Problem {
    public int numberOfCities_;
    public double[][] distanceMatrix_;

    public TSP(String solutionType) {
        this(solutionType, "eil101.tsp");
    }

    public TSP(String solutionType, String filename) {
        this.numberOfVariables_ = 1;
        this.numberOfObjectives_ = 1;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "TSP";
        this.solutionType_ = new PermutationSolutionType(this);
        this.length_ = new int[this.numberOfVariables_];
        try {
            if (solutionType.compareTo("Permutation") != 0) {
                throw new JMException("Solution type invalid");
            }
            this.solutionType_ = new PermutationSolutionType(this);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        try {
            this.readProblem(filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(this.numberOfCities_);
        this.length_[0] = this.numberOfCities_;
    }

    @Override
    public void evaluate(Solution solution) {
        double fitness = 0.0;
        for (int i = 0; i < this.numberOfCities_ - 1; ++i) {
            int x = ((Permutation)solution.getDecisionVariables()[0]).vector_[i];
            int y = ((Permutation)solution.getDecisionVariables()[0]).vector_[i + 1];
            fitness += this.distanceMatrix_[x][y];
        }
        int firstCity = ((Permutation)solution.getDecisionVariables()[0]).vector_[0];
        int lastCity = ((Permutation)solution.getDecisionVariables()[0]).vector_[this.numberOfCities_ - 1];
        solution.setObjective(0, fitness += this.distanceMatrix_[firstCity][lastCity]);
    }

    public void readProblem(String fileName) throws IOException {
        BufferedReader inputFile = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        StreamTokenizer token = new StreamTokenizer(inputFile);
        try {
            boolean found = false;
            token.nextToken();
            while (!found) {
                if (token.sval != null && token.sval.compareTo("DIMENSION") == 0) {
                    found = true;
                    continue;
                }
                token.nextToken();
            }
            token.nextToken();
            token.nextToken();
            this.numberOfCities_ = (int)token.nval;
            this.distanceMatrix_ = new double[this.numberOfCities_][this.numberOfCities_];
            found = false;
            token.nextToken();
            while (!found) {
                if (token.sval != null && token.sval.compareTo("SECTION") == 0) {
                    found = true;
                    continue;
                }
                token.nextToken();
            }
            double[] c = new double[2 * this.numberOfCities_];
            for (int i = 0; i < this.numberOfCities_; ++i) {
                token.nextToken();
                int j = (int)token.nval;
                token.nextToken();
                c[2 * (j - 1)] = token.nval;
                token.nextToken();
                c[2 * (j - 1) + 1] = token.nval;
            }
            for (int k = 0; k < this.numberOfCities_; ++k) {
                this.distanceMatrix_[k][k] = 0.0;
                for (int j = k + 1; j < this.numberOfCities_; ++j) {
                    double dist = Math.sqrt(Math.pow(c[k * 2] - c[j * 2], 2.0) + Math.pow(c[k * 2 + 1] - c[j * 2 + 1], 2.0));
                    this.distanceMatrix_[k][j] = dist = (double)((int)(dist + 0.5));
                    this.distanceMatrix_[j][k] = dist;
                }
            }
        }
        catch (Exception e) {
            System.err.println("TSP.readProblem(): error when reading data file " + e);
            System.exit(1);
        }
    }
}

