/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import java.util.Arrays;
import jmetal.qualityIndicator.util.LexicoGraphicalComparator;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.qualityIndicator.util.ValueComparator;

public class GeneralizedSpread {
    public static MetricsUtil utils_;

    public GeneralizedSpread() {
        utils_ = new MetricsUtil();
    }

    public double generalizedSpread(double[][] paretoFront, double[][] paretoTrueFront, int numberOfObjectives) {
        double[] maximumValue = utils_.getMaximumValues(paretoTrueFront, numberOfObjectives);
        double[] minimumValue = utils_.getMinimumValues(paretoTrueFront, numberOfObjectives);
        double[][] normalizedFront = utils_.getNormalizedFront(paretoFront, maximumValue, minimumValue);
        double[][] normalizedParetoFront = utils_.getNormalizedFront(paretoTrueFront, maximumValue, minimumValue);
        double[][] extremValues = new double[numberOfObjectives][numberOfObjectives];
        for (int i = 0; i < numberOfObjectives; ++i) {
            Arrays.sort(normalizedParetoFront, new ValueComparator(i));
            System.arraycopy(normalizedParetoFront[normalizedParetoFront.length - 1], 0, extremValues[i], 0, numberOfObjectives);
        }
        int numberOfPoints = normalizedFront.length;
        int numberOfTruePoints = normalizedParetoFront.length;
        Arrays.sort(normalizedFront, new LexicoGraphicalComparator());
        if (utils_.distance(normalizedFront[0], normalizedFront[normalizedFront.length - 1]) == 0.0) {
            return 1.0;
        }
        double dmean = 0.0;
        for (double[] aNormalizedFront : normalizedFront) {
            dmean += utils_.distanceToNearestPoint(aNormalizedFront, normalizedFront);
        }
        dmean /= (double)numberOfPoints;
        double dExtrems = 0.0;
        for (double[] extremValue : extremValues) {
            dExtrems += utils_.distanceToClosedPoint(extremValue, normalizedFront);
        }
        double mean = 0.0;
        for (double[] aNormalizedFront : normalizedFront) {
            mean += Math.abs(utils_.distanceToNearestPoint(aNormalizedFront, normalizedFront) - dmean);
        }
        double value = (dExtrems + mean) / (dExtrems + (double)numberOfPoints * dmean);
        return value;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Error using GeneralizedSpread. Usage: \n java GeneralizedSpread <SolutionFrontFile>  <TrueFrontFile> + <getNumberOfObjectives>");
            System.exit(1);
        }
        GeneralizedSpread qualityIndicator = new GeneralizedSpread();
        double[][] solutionFront = utils_.readFront(args[0]);
        double[][] trueFront = utils_.readFront(args[1]);
        double value = qualityIndicator.generalizedSpread(solutionFront, trueFront, new Integer(args[2]));
        System.out.println(value);
    }
}

