/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.Epsilon;
import jmetal.qualityIndicator.GenerationalDistance;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.qualityIndicator.InvertedGenerationalDistance;
import jmetal.qualityIndicator.Spread;
import jmetal.qualityIndicator.util.MetricsUtil;

public class QualityIndicator {
    SolutionSet trueParetoFront_;
    double trueParetoFrontHypervolume_;
    Problem problem_;
    public MetricsUtil utils_;

    public QualityIndicator(Problem problem, String paretoFrontFile) {
        this.problem_ = problem;
        this.utils_ = new MetricsUtil();
        this.trueParetoFront_ = this.utils_.readNonDominatedSolutionSet(paretoFrontFile);
        this.trueParetoFrontHypervolume_ = new Hypervolume().hypervolume(this.trueParetoFront_.writeObjectivesToMatrix(), this.trueParetoFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public double getHypervolume(SolutionSet solutionSet) {
        return new Hypervolume().hypervolume(solutionSet.writeObjectivesToMatrix(), this.trueParetoFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public double getTrueParetoFrontHypervolume() {
        return this.trueParetoFrontHypervolume_;
    }

    public double getIGD(SolutionSet solutionSet) {
        return new InvertedGenerationalDistance().invertedGenerationalDistance(solutionSet.writeObjectivesToMatrix(), this.trueParetoFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public double getGD(SolutionSet solutionSet) {
        return new GenerationalDistance().generationalDistance(solutionSet.writeObjectivesToMatrix(), this.trueParetoFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public double getSpread(SolutionSet solutionSet) {
        return new Spread().spread(solutionSet.writeObjectivesToMatrix(), this.trueParetoFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public double getEpsilon(SolutionSet solutionSet) {
        return new Epsilon().epsilon(solutionSet.writeObjectivesToMatrix(), this.trueParetoFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }
}

