/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.util.MetricsUtil;

public class R2 {
    public MetricsUtil utils_ = new MetricsUtil();
    double[][] matrix_ = null;
    double[][] lambda_ = null;
    int nObj_ = 0;

    public R2() {
        this.nObj_ = 2;
        this.lambda_ = new double[100][2];
        for (int n = 0; n < 100; ++n) {
            double a;
            this.lambda_[n][0] = a = 1.0 * (double)n / 99.0;
            this.lambda_[n][1] = 1.0 - a;
        }
    }

    public R2(int nVectors) {
        this.nObj_ = 2;
        this.lambda_ = new double[nVectors][2];
        for (int n = 0; n < nVectors; ++n) {
            double a;
            this.lambda_[n][0] = a = 1.0 * (double)n / (double)(nVectors - 1);
            this.lambda_[n][1] = 1.0 - a;
        }
    }

    public R2(int nObj, String file) {
        this.nObj_ = nObj;
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            int numberOfObjectives = 0;
            boolean i = false;
            int j = 0;
            String aux = br.readLine();
            LinkedList<double[]> list = new LinkedList<double[]>();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                j = 0;
                numberOfObjectives = st.countTokens();
                double[] vector = new double[nObj];
                while (st.hasMoreTokens()) {
                    double value = new Double(st.nextToken());
                    vector[j++] = value;
                }
                list.add(vector);
                aux = br.readLine();
            }
            br.close();
            this.lambda_ = new double[list.size()][];
            int index = 0;
            for (double[] aList : list) {
                this.lambda_[index++] = aList;
            }
        }
        catch (Exception e) {
            System.out.println("initUniformWeight: failed when reading for file: " + file);
            e.printStackTrace();
        }
    }

    private double R2Withouth(double[][] approximation, double[][] paretoFront, int index) {
        double[] maximumValue = this.utils_.getMaximumValues(paretoFront, this.nObj_);
        double[] minimumValue = this.utils_.getMinimumValues(paretoFront, this.nObj_);
        double[][] normalizedApproximation = this.utils_.getNormalizedFront(approximation, maximumValue, minimumValue);
        double[][] normalizedParetoFront = this.utils_.getNormalizedFront(paretoFront, maximumValue, minimumValue);
        this.matrix_ = new double[approximation.length][this.lambda_.length];
        for (int i = 0; i < approximation.length; ++i) {
            for (int j = 0; j < this.lambda_.length; ++j) {
                this.matrix_[i][j] = this.lambda_[j][0] * Math.abs(normalizedApproximation[i][0]);
                for (int n = 1; n < this.nObj_; ++n) {
                    this.matrix_[i][j] = Math.max(this.matrix_[i][j], this.lambda_[j][n] * Math.abs(normalizedApproximation[i][n]));
                }
            }
        }
        double sumWithout = 0.0;
        for (int i = 0; i < this.lambda_.length; ++i) {
            double tmp = index != 0 ? this.matrix_[0][i] : this.matrix_[1][i];
            for (int j = 0; j < approximation.length; ++j) {
                if (j == index) continue;
                tmp = Math.min(tmp, this.matrix_[j][i]);
            }
            sumWithout += tmp;
        }
        return sumWithout / (double)this.lambda_.length;
    }

    public int getBest(double[][] approximation, double[][] paretoFront) {
        int index_best = -1;
        double value = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < approximation.length; ++i) {
            double aux = this.R2Withouth(approximation, paretoFront, i);
            if (!(aux > value)) continue;
            index_best = i;
            value = aux;
        }
        return index_best;
    }

    public int getWorst(double[][] approximation, double[][] paretoFront) {
        int index_worst = -1;
        double value = Double.POSITIVE_INFINITY;
        for (int i = 0; i < approximation.length; ++i) {
            double aux = this.R2Withouth(approximation, paretoFront, i);
            if (!(aux < value)) continue;
            index_worst = i;
            value = aux;
        }
        return index_worst;
    }

    public int getBest(SolutionSet set) {
        double[][] approximationFront = set.writeObjectivesToMatrix();
        double[][] trueFront = set.writeObjectivesToMatrix();
        return this.getBest(approximationFront, trueFront);
    }

    public int getWorst(SolutionSet set) {
        double[][] approximationFront = set.writeObjectivesToMatrix();
        double[][] trueFront = set.writeObjectivesToMatrix();
        return this.getWorst(approximationFront, trueFront);
    }

    public int[] getNBest(double[][] approximation, double[][] paretoFront, int N) {
        int i;
        int[] index_bests = new int[approximation.length];
        double[] values = new double[approximation.length];
        for (i = 0; i < approximation.length; ++i) {
            values[i] = this.R2Withouth(approximation, paretoFront, i);
            index_bests[i] = i;
        }
        for (i = 0; i < approximation.length; ++i) {
            for (int j = i; j < approximation.length; ++j) {
                if (!(values[j] < values[i])) continue;
                double aux = values[j];
                values[j] = values[i];
                values[i] = aux;
                int aux_index = index_bests[j];
                index_bests[j] = index_bests[i];
                index_bests[i] = aux_index;
            }
        }
        int[] res = new int[N];
        for (int i2 = 0; i2 < N; ++i2) {
            res[i2] = index_bests[i2];
        }
        return res;
    }

    public int[] getNBest(SolutionSet set, int N) {
        double[][] approximationFront = set.writeObjectivesToMatrix();
        double[][] trueFront = set.writeObjectivesToMatrix();
        return this.getNBest(approximationFront, trueFront, N);
    }

    public double R2(double[][] approximation, double[][] paretoFront) {
        double[] maximumValue = this.utils_.getMaximumValues(paretoFront, this.nObj_);
        double[] minimumValue = this.utils_.getMinimumValues(paretoFront, this.nObj_);
        double[][] normalizedApproximation = this.utils_.getNormalizedFront(approximation, maximumValue, minimumValue);
        double[][] normalizedParetoFront = this.utils_.getNormalizedFront(paretoFront, maximumValue, minimumValue);
        this.matrix_ = new double[approximation.length][this.lambda_.length];
        for (int i = 0; i < approximation.length; ++i) {
            for (int j = 0; j < this.lambda_.length; ++j) {
                this.matrix_[i][j] = this.lambda_[j][0] * Math.abs(normalizedApproximation[i][0]);
                for (int n = 1; n < this.nObj_; ++n) {
                    this.matrix_[i][j] = Math.max(this.matrix_[i][j], this.lambda_[j][n] * Math.abs(normalizedApproximation[i][n]));
                }
            }
        }
        double sum = 0.0;
        for (int i = 0; i < this.lambda_.length; ++i) {
            double tmp = this.matrix_[0][i];
            for (int j = 1; j < approximation.length; ++j) {
                tmp = Math.min(tmp, this.matrix_[j][i]);
            }
            sum += tmp;
        }
        return sum / (double)this.lambda_.length;
    }

    public double R2(SolutionSet set) {
        double[][] approximationFront = set.writeObjectivesToMatrix();
        double[][] trueFront = set.writeObjectivesToMatrix();
        return this.R2(approximationFront, trueFront);
    }

    public double R2Without(SolutionSet set, int index) {
        double[][] approximationFront = set.writeObjectivesToMatrix();
        double[][] trueFront = set.writeObjectivesToMatrix();
        return this.R2(approximationFront, trueFront);
    }

    public static void main(String[] args) {
        int nObj;
        if (args.length < 3) {
            System.err.println("Error using R2. Usage: \n java jmetal.qualityIndicator.Hypervolume <SolutionFrontFile> <TrueFrontFile> <getNumberOfObjectives>");
            System.exit(1);
        }
        R2 qualityIndicator = (nObj = new Integer(args[2]).intValue()) == 2 && args.length == 3 ? new R2() : new R2(nObj, args[3]);
        double[][] approximationFront = qualityIndicator.utils_.readFront(args[0]);
        double[][] paretoFront = qualityIndicator.utils_.readFront(args[1]);
        double value = qualityIndicator.R2(approximationFront, paretoFront);
        System.out.println(value);
        System.out.println(qualityIndicator.R2Withouth(approximationFront, paretoFront, 1));
        System.out.println(qualityIndicator.R2Withouth(approximationFront, paretoFront, 15));
        System.out.println(qualityIndicator.R2Withouth(approximationFront, paretoFront, 25));
        System.out.println(qualityIndicator.R2Withouth(approximationFront, paretoFront, 75));
    }
}

