/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import java.util.Arrays;
import jmetal.qualityIndicator.util.LexicoGraphicalComparator;
import jmetal.qualityIndicator.util.MetricsUtil;

public class Spread {
    public static MetricsUtil utils_;

    public Spread() {
        utils_ = new MetricsUtil();
    }

    public double spread(double[][] front, double[][] trueParetoFront, int numberOfObjectives) {
        int i;
        double[] maximumValue = utils_.getMaximumValues(trueParetoFront, numberOfObjectives);
        double[] minimumValue = utils_.getMinimumValues(trueParetoFront, numberOfObjectives);
        double[][] normalizedFront = utils_.getNormalizedFront(front, maximumValue, minimumValue);
        double[][] normalizedParetoFront = utils_.getNormalizedFront(trueParetoFront, maximumValue, minimumValue);
        Arrays.sort(normalizedFront, new LexicoGraphicalComparator());
        Arrays.sort(normalizedParetoFront, new LexicoGraphicalComparator());
        int numberOfPoints = normalizedFront.length;
        double df = utils_.distance(normalizedFront[0], normalizedParetoFront[0]);
        double dl = utils_.distance(normalizedFront[normalizedFront.length - 1], normalizedParetoFront[normalizedParetoFront.length - 1]);
        double mean = 0.0;
        double diversitySum = df + dl;
        for (i = 0; i < normalizedFront.length - 1; ++i) {
            mean += utils_.distance(normalizedFront[i], normalizedFront[i + 1]);
        }
        mean /= (double)(numberOfPoints - 1);
        if (numberOfPoints > 1) {
            for (i = 0; i < numberOfPoints - 1; ++i) {
                diversitySum += Math.abs(utils_.distance(normalizedFront[i], normalizedFront[i + 1]) - mean);
            }
            return diversitySum / (df + dl + (double)(numberOfPoints - 1) * mean);
        }
        return 1.0;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Spread::Main: Error using Spread. Usage: \n java Spread <FrontFile> <TrueFrontFile>  <getNumberOfObjectives>");
            System.exit(1);
        }
        Spread qualityIndicator = new Spread();
        double[][] solutionFront = utils_.readFront(args[0]);
        double[][] trueFront = utils_.readFront(args[1]);
        double value = qualityIndicator.spread(solutionFront, trueFront, 2);
        System.out.println(value);
    }
}

