/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator.fastHypervolume;

import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.fastHypervolume.wfg.Front;
import jmetal.qualityIndicator.fastHypervolume.wfg.WFGHV;
import jmetal.util.comparators.ObjectiveComparator;

public class FastHypervolume {
    Solution referencePoint_ = null;
    int numberOfObjectives_ = 0;
    double offset_ = 20.0;

    public FastHypervolume() {
    }

    public FastHypervolume(double offset) {
        this.offset_ = offset;
    }

    public double computeHypervolume(SolutionSet solutionSet) {
        double hv;
        if (solutionSet.size() == 0) {
            hv = 0.0;
        } else {
            this.numberOfObjectives_ = solutionSet.get(0).getNumberOfObjectives();
            this.referencePoint_ = new Solution(this.numberOfObjectives_);
            this.updateReferencePoint(solutionSet);
            if (this.numberOfObjectives_ == 2) {
                solutionSet.sort(new ObjectiveComparator(this.numberOfObjectives_ - 1, true));
                hv = this.get2DHV(solutionSet);
            } else {
                this.updateReferencePoint(solutionSet);
                Front front = new Front(solutionSet.size(), this.numberOfObjectives_, solutionSet);
                hv = new WFGHV(this.numberOfObjectives_, solutionSet.size(), this.referencePoint_).getHV(front);
            }
        }
        return hv;
    }

    public double computeHypervolume(SolutionSet solutionSet, Solution referencePoint) {
        double hv = 0.0;
        if (solutionSet.size() == 0) {
            hv = 0.0;
        } else {
            this.numberOfObjectives_ = solutionSet.get(0).getNumberOfObjectives();
            this.referencePoint_ = referencePoint;
            if (this.numberOfObjectives_ == 2) {
                solutionSet.sort(new ObjectiveComparator(this.numberOfObjectives_ - 1, true));
                hv = this.get2DHV(solutionSet);
            } else {
                WFGHV wfg = new WFGHV(this.numberOfObjectives_, solutionSet.size());
                Front front = new Front(solutionSet.size(), this.numberOfObjectives_, solutionSet);
                hv = wfg.getHV(front, referencePoint);
            }
        }
        return hv;
    }

    private void updateReferencePoint(SolutionSet solutionSet) {
        int i;
        double[] maxObjectives = new double[this.numberOfObjectives_];
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            maxObjectives[i] = 0.0;
        }
        for (i = 0; i < solutionSet.size(); ++i) {
            for (int j = 0; j < this.numberOfObjectives_; ++j) {
                if (!(maxObjectives[j] < solutionSet.get(i).getObjective(j))) continue;
                maxObjectives[j] = solutionSet.get(i).getObjective(j);
            }
        }
        for (i = 0; i < this.referencePoint_.getNumberOfObjectives(); ++i) {
            this.referencePoint_.setObjective(i, maxObjectives[i] + this.offset_);
        }
    }

    public double get2DHV(SolutionSet solutionSet) {
        double hv = 0.0;
        if (solutionSet.size() > 0) {
            hv = Math.abs((solutionSet.get(0).getObjective(0) - this.referencePoint_.getObjective(0)) * (solutionSet.get(0).getObjective(1) - this.referencePoint_.getObjective(1)));
            for (int i = 1; i < solutionSet.size(); ++i) {
                double tmp = Math.abs((solutionSet.get(i).getObjective(0) - this.referencePoint_.getObjective(0)) * (solutionSet.get(i).getObjective(1) - solutionSet.get(i - 1).getObjective(1)));
                hv += tmp;
            }
        }
        return hv;
    }

    public void computeHVContributions(SolutionSet solutionSet) {
        int i;
        double[] contributions = new double[solutionSet.size()];
        double solutionSetHV = 0.0;
        solutionSetHV = this.computeHypervolume(solutionSet);
        for (i = 0; i < solutionSet.size(); ++i) {
            Solution currentPoint = solutionSet.get(i);
            solutionSet.remove(i);
            if (this.numberOfObjectives_ == 2) {
                contributions[i] = solutionSetHV - this.get2DHV(solutionSet);
            } else {
                Front front = new Front(solutionSet.size(), this.numberOfObjectives_, solutionSet);
                double hv = new WFGHV(this.numberOfObjectives_, solutionSet.size(), this.referencePoint_).getHV(front);
                contributions[i] = solutionSetHV - hv;
            }
            solutionSet.add(i, currentPoint);
        }
        for (i = 0; i < solutionSet.size(); ++i) {
            solutionSet.get(i).setCrowdingDistance(contributions[i]);
        }
    }
}

