/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator.fastHypervolume;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.qualityIndicator.fastHypervolume.FastHypervolume;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;

public class FastHypervolumeArchive
extends Archive {
    private int maxSize_;
    private int objectives_;
    private Comparator dominance_;
    private Comparator equals_;
    private Comparator crowdingDistance_;
    public Solution referencePoint_;

    public FastHypervolumeArchive(int maxSize, int numberOfObjectives) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.objectives_ = numberOfObjectives;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.referencePoint_ = new Solution(this.objectives_);
        for (int i = 0; i < this.objectives_; ++i) {
            this.referencePoint_.setObjective(i, Double.MAX_VALUE);
        }
        this.crowdingDistance_ = new CrowdingComparator();
    }

    @Override
    public boolean add(Solution solution) {
        int flag = 0;
        int i = 0;
        while (i < this.solutionsList_.size()) {
            Solution aux = (Solution)this.solutionsList_.get(i);
            flag = this.dominance_.compare(solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionsList_.remove(i);
                continue;
            }
            if (this.equals_.compare(aux, solution) == 0) {
                return false;
            }
            ++i;
        }
        this.solutionsList_.add(solution);
        if (this.size() > this.maxSize_) {
            this.computeHVContribution();
            this.remove(this.indexWorst(this.crowdingDistance_));
        }
        return true;
    }

    public void computeHVContribution() {
        if (this.size() > 2) {
            FastHypervolume fastHV = new FastHypervolume();
            fastHV.computeHVContributions(this);
        }
    }
}

