/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator.fastHypervolume.wfg;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.fastHypervolume.wfg.Point;
import jmetal.qualityIndicator.fastHypervolume.wfg.PointComparator;

public class Front {
    private int numberOfPoints_;
    private int dimension_;
    public Point[] points_;
    private boolean maximizing_ = true;
    public int nPoints_;
    private Comparator pointComparator = new PointComparator(this.maximizing_);

    public Front() {
    }

    public Front(int numberOfPoints, int dimension, SolutionSet solutionSet) {
        this.numberOfPoints_ = numberOfPoints;
        this.dimension_ = dimension;
        this.nPoints_ = this.numberOfPoints_;
        this.points_ = new Point[this.numberOfPoints_];
        for (int i = 0; i < this.numberOfPoints_; ++i) {
            double[] p = new double[dimension];
            for (int j = 0; j < dimension; ++j) {
                p[j] = solutionSet.get(i).getObjective(j);
            }
            this.points_[i] = new Point(p);
        }
    }

    public Front(int numberOfPoints, int dimension) {
        this.numberOfPoints_ = numberOfPoints;
        this.dimension_ = dimension;
        this.nPoints_ = this.numberOfPoints_;
        this.points_ = new Point[this.numberOfPoints_];
        for (int i = 0; i < this.numberOfPoints_; ++i) {
            double[] p = new double[dimension];
            for (int j = 0; j < dimension; ++j) {
                p[j] = 0.0;
            }
            this.points_[i] = new Point(p);
        }
    }

    public Front(int numberOfPoints, int dimension, List<double[]> listOfPoints) {
        this.numberOfPoints_ = numberOfPoints;
        this.dimension_ = dimension;
        this.points_ = new Point[this.numberOfPoints_];
        for (int i = 0; i < this.numberOfPoints_; ++i) {
            this.points_[i] = new Point(listOfPoints.get(i));
        }
    }

    public void readFront(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<double[]> list = new ArrayList<double[]>();
        int numberOfObjectives = 0;
        String aux = br.readLine();
        while (aux != null) {
            StringTokenizer st = new StringTokenizer(aux);
            int i = 0;
            numberOfObjectives = st.countTokens();
            double[] vector = new double[st.countTokens()];
            while (st.hasMoreTokens()) {
                double value;
                vector[i] = value = new Double(st.nextToken()).doubleValue();
                ++i;
            }
            list.add(vector);
            aux = br.readLine();
        }
        this.numberOfPoints_ = list.size();
        this.dimension_ = numberOfObjectives;
        this.points_ = new Point[this.numberOfPoints_];
        this.nPoints_ = this.numberOfPoints_;
        for (int i = 0; i < this.numberOfPoints_; ++i) {
            this.points_[i] = new Point((double[])list.get(i));
        }
    }

    public void loadFront(SolutionSet solutionSet, int notLoadingIndex) {
        this.numberOfPoints_ = notLoadingIndex >= 0 && notLoadingIndex < solutionSet.size() ? solutionSet.size() - 1 : solutionSet.size();
        this.nPoints_ = this.numberOfPoints_;
        this.dimension_ = solutionSet.get(0).getNumberOfObjectives();
        this.points_ = new Point[this.numberOfPoints_];
        int index = 0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            if (i == notLoadingIndex) continue;
            double[] vector = new double[this.dimension_];
            for (int j = 0; j < this.dimension_; ++j) {
                vector[j] = solutionSet.get(i).getObjective(j);
            }
            this.points_[index++] = new Point(vector);
        }
    }

    public void printFront() {
        System.out.println("Objectives:       " + this.dimension_);
        System.out.println("Number of points: " + this.numberOfPoints_);
        for (Point point : this.points_) {
            System.out.println(point);
        }
    }

    public int getNumberOfObjectives() {
        return this.dimension_;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints_;
    }

    public Point getPoint(int index) {
        return this.points_[index];
    }

    public Point[] getPoints() {
        return this.points_;
    }

    public void setToMazimize() {
        this.maximizing_ = true;
        this.pointComparator = new PointComparator(this.maximizing_);
    }

    public void setToMinimize() {
        this.maximizing_ = false;
        this.pointComparator = new PointComparator(this.maximizing_);
    }

    public void sort() {
        Arrays.sort(this.points_, this.pointComparator);
    }

    public Point getReferencePoint() {
        int i;
        Point referencePoint = new Point(this.dimension_);
        double[] maxObjectives = new double[this.numberOfPoints_];
        for (i = 0; i < this.numberOfPoints_; ++i) {
            maxObjectives[i] = 0.0;
        }
        for (i = 0; i < this.points_.length; ++i) {
            for (int j = 0; j < this.dimension_; ++j) {
                if (!(maxObjectives[j] < this.points_[i].objectives_[j])) continue;
                maxObjectives[j] = this.points_[i].objectives_[j];
            }
        }
        for (i = 0; i < this.dimension_; ++i) {
            referencePoint.objectives_[i] = maxObjectives[i];
        }
        return referencePoint;
    }
}

