/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator.fastHypervolume.wfg;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.fastHypervolume.wfg.Front;
import jmetal.qualityIndicator.fastHypervolume.wfg.Point;
import jmetal.qualityIndicator.fastHypervolume.wfg.PointComparator;

public class WFGHV {
    Front[] fs_;
    Point referencePoint_;
    boolean maximizing_;
    int currentDeep_;
    int currentDimension_;
    int maxNumberOfPoints_;
    int maxNumberOfObjectives_;
    final int OPT = 2;
    Comparator pointComparator_;

    public WFGHV(int dimension, int maxNumberOfPoints) {
        this.referencePoint_ = null;
        this.maximizing_ = false;
        this.currentDeep_ = 0;
        this.currentDimension_ = dimension;
        this.maxNumberOfPoints_ = maxNumberOfPoints;
        this.maxNumberOfObjectives_ = dimension;
        this.pointComparator_ = new PointComparator(true);
        int maxd = this.maxNumberOfPoints_ - 2;
        this.fs_ = new Front[maxd];
        for (int i = 0; i < maxd; ++i) {
            this.fs_[i] = new Front(maxNumberOfPoints, dimension);
        }
    }

    public WFGHV(int dimension, int maxNumberOfPoints, Solution referencePoint) {
        this.referencePoint_ = new Point(referencePoint);
        this.maximizing_ = false;
        this.currentDeep_ = 0;
        this.currentDimension_ = dimension;
        this.maxNumberOfPoints_ = maxNumberOfPoints;
        this.maxNumberOfObjectives_ = dimension;
        this.pointComparator_ = new PointComparator(true);
        int maxd = this.maxNumberOfPoints_ - 2;
        this.fs_ = new Front[maxd];
        for (int i = 0; i < maxd; ++i) {
            this.fs_[i] = new Front(maxNumberOfPoints, dimension);
        }
    }

    public WFGHV(int dimension, int maxNumberOfPoints, Point referencePoint) {
        this.referencePoint_ = referencePoint;
        this.maximizing_ = false;
        this.currentDeep_ = 0;
        this.currentDimension_ = dimension;
        this.maxNumberOfPoints_ = maxNumberOfPoints;
        this.maxNumberOfObjectives_ = dimension;
        this.pointComparator_ = new PointComparator(true);
        int maxd = this.maxNumberOfPoints_ - 2;
        this.fs_ = new Front[maxd];
        for (int i = 0; i < maxd; ++i) {
            this.fs_[i] = new Front(maxNumberOfPoints, dimension);
        }
    }

    public int getLessContributorHV(SolutionSet set) {
        Front wholeFront = new Front();
        wholeFront.loadFront(set, -1);
        int index = 0;
        double contribution = Double.POSITIVE_INFINITY;
        for (int i = 0; i < set.size(); ++i) {
            double[] v = new double[set.get(i).getNumberOfObjectives()];
            for (int j = 0; j < v.length; ++j) {
                v[j] = set.get(i).getObjective(j);
            }
            Point p = new Point(v);
            double aux = this.getExclusiveHV(wholeFront, i);
            if (aux < contribution) {
                index = i;
                contribution = aux;
            }
            set.get(i).setCrowdingDistance(aux);
        }
        return index;
    }

    public double getHV(Front front, Solution referencePoint) {
        this.referencePoint_ = new Point(referencePoint);
        double volume = 0.0;
        this.sort(front);
        if (this.currentDimension_ == 2) {
            volume = this.get2DHV(front);
        } else {
            volume = 0.0;
            --this.currentDimension_;
            for (int i = front.nPoints_ - 1; i >= 0; --i) {
                volume += Math.abs(front.getPoint((int)i).objectives_[this.currentDimension_] - this.referencePoint_.objectives_[this.currentDimension_]) * this.getExclusiveHV(front, i);
            }
            ++this.currentDimension_;
        }
        return volume;
    }

    public double getHV(Front front) {
        double volume = 0.0;
        this.sort(front);
        if (this.currentDimension_ == 2) {
            volume = this.get2DHV(front);
        } else {
            volume = 0.0;
            --this.currentDimension_;
            for (int i = front.nPoints_ - 1; i >= 0; --i) {
                volume += Math.abs(front.getPoint((int)i).objectives_[this.currentDimension_] - this.referencePoint_.objectives_[this.currentDimension_]) * this.getExclusiveHV(front, i);
            }
            ++this.currentDimension_;
        }
        return volume;
    }

    public double get2DHV(Front front) {
        double hv = 0.0;
        hv = Math.abs((front.getPoint(0).getObjectives()[0] - this.referencePoint_.objectives_[0]) * (front.getPoint(0).getObjectives()[1] - this.referencePoint_.objectives_[1]));
        for (int i = 1; i < front.nPoints_; ++i) {
            hv += Math.abs((front.getPoint(i).getObjectives()[0] - this.referencePoint_.objectives_[0]) * (front.getPoint(i).getObjectives()[1] - front.getPoint(i - 1).getObjectives()[1]));
        }
        return hv;
    }

    public double getInclusiveHV(Point p) {
        double volume = 1.0;
        for (int i = 0; i < this.currentDimension_; ++i) {
            volume *= Math.abs(p.objectives_[i] - this.referencePoint_.objectives_[i]);
        }
        return volume;
    }

    public double getExclusiveHV(Front front, int point) {
        double volume = this.getInclusiveHV(front.getPoint(point));
        if (front.nPoints_ > point + 1) {
            this.makeDominatedBit(front, point);
            double v = this.getHV(this.fs_[this.currentDeep_ - 1]);
            volume -= v;
            --this.currentDeep_;
        }
        return volume;
    }

    public void makeDominatedBit(Front front, int p) {
        int z = front.nPoints_ - 1 - p;
        for (int i = 0; i < z; ++i) {
            for (int j = 0; j < this.currentDimension_; ++j) {
                this.fs_[this.currentDeep_].getPoint((int)i).objectives_[j] = this.worse(front.points_[p].objectives_[j], front.points_[p + 1 + i].objectives_[j], false);
            }
        }
        this.fs_[this.currentDeep_].nPoints_ = 1;
        for (int i = 1; i < z; ++i) {
            int j = 0;
            boolean keep = true;
            block7: while (j < this.fs_[this.currentDeep_].nPoints_ && keep) {
                switch (this.dominates2way(this.fs_[this.currentDeep_].points_[i], this.fs_[this.currentDeep_].points_[j])) {
                    case -1: {
                        Point t = this.fs_[this.currentDeep_].points_[j];
                        --this.fs_[this.currentDeep_].nPoints_;
                        this.fs_[this.currentDeep_].points_[j] = this.fs_[this.currentDeep_].points_[this.fs_[this.currentDeep_].nPoints_];
                        this.fs_[this.currentDeep_].points_[this.fs_[this.currentDeep_].nPoints_] = t;
                        continue block7;
                    }
                    case 0: {
                        ++j;
                        continue block7;
                    }
                }
                keep = false;
            }
            if (!keep) continue;
            Point t = this.fs_[this.currentDeep_].points_[this.fs_[this.currentDeep_].nPoints_];
            this.fs_[this.currentDeep_].points_[this.fs_[this.currentDeep_].nPoints_] = this.fs_[this.currentDeep_].points_[i];
            this.fs_[this.currentDeep_].points_[i] = t;
            ++this.fs_[this.currentDeep_].nPoints_;
        }
        ++this.currentDeep_;
    }

    private double worse(double x, double y, boolean maximizing) {
        double result = maximizing ? (x > y ? y : x) : (x > y ? x : y);
        return result;
    }

    int dominates2way(Point p, Point q) {
        for (int i = this.currentDimension_ - 1; i >= 0; --i) {
            if (p.objectives_[i] < q.objectives_[i]) {
                for (int j = i - 1; j >= 0; --j) {
                    if (!(q.objectives_[j] < p.objectives_[j])) continue;
                    return 0;
                }
                return -1;
            }
            if (!(q.objectives_[i] < p.objectives_[i])) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (!(p.objectives_[j] < q.objectives_[j])) continue;
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public void sort(Front front) {
        Arrays.sort(front.points_, 0, front.nPoints_, this.pointComparator_);
    }

    public static void main(String[] args) throws IOException {
        int i;
        Front front = new Front();
        if (args.length == 0) {
            System.out.println("Usage: WFGHV front [reference point]");
            System.exit(-1);
        }
        if (args.length > 0) {
            front.readFront(args[0]);
        }
        int dimensions = front.getNumberOfObjectives();
        double[] points = new double[dimensions];
        if (args.length == dimensions + 1) {
            for (i = 1; i <= dimensions; ++i) {
                points[i - 1] = Double.parseDouble(args[i]);
            }
        } else {
            for (i = 1; i <= dimensions; ++i) {
                points[i - 1] = 0.0;
            }
        }
        Point referencePoint = new Point(points);
        System.out.println("Using reference point: " + referencePoint);
        WFGHV wfghv = new WFGHV(referencePoint.getNumberOfObjectives(), front.getNumberOfPoints(), referencePoint);
        System.out.println("hv = " + wfghv.getHV(front));
    }
}

