/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.util.NonDominatedSolutionList;

public class MetricsUtil {
    public double[][] readFront(String path) {
        try {
            int i;
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            ArrayList<double[]> list = new ArrayList<double[]>();
            int numberOfObjectives = 0;
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                i = 0;
                numberOfObjectives = st.countTokens();
                double[] vector = new double[st.countTokens()];
                while (st.hasMoreTokens()) {
                    double value;
                    vector[i] = value = new Double(st.nextToken()).doubleValue();
                    ++i;
                }
                list.add(vector);
                aux = br.readLine();
            }
            br.close();
            double[][] front = new double[list.size()][numberOfObjectives];
            for (i = 0; i < list.size(); ++i) {
                front[i] = (double[])list.get(i);
            }
            return front;
        }
        catch (Exception e) {
            System.out.println("InputFacilities crashed reading for file: " + path);
            e.printStackTrace();
            return null;
        }
    }

    public double[] getMaximumValues(double[][] front, int noObjectives) {
        double[] maximumValue = new double[noObjectives];
        for (int i = 0; i < noObjectives; ++i) {
            maximumValue[i] = Double.NEGATIVE_INFINITY;
        }
        for (double[] aFront : front) {
            for (int j = 0; j < aFront.length; ++j) {
                if (!(aFront[j] > maximumValue[j])) continue;
                maximumValue[j] = aFront[j];
            }
        }
        return maximumValue;
    }

    public double[] getMinimumValues(double[][] front, int noObjectives) {
        double[] minimumValue = new double[noObjectives];
        for (int i = 0; i < noObjectives; ++i) {
            minimumValue[i] = Double.MAX_VALUE;
        }
        for (double[] aFront : front) {
            for (int j = 0; j < aFront.length; ++j) {
                if (!(aFront[j] < minimumValue[j])) continue;
                minimumValue[j] = aFront[j];
            }
        }
        return minimumValue;
    }

    public double distance(double[] a, double[] b) {
        double distance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            distance += Math.pow(a[i] - b[i], 2.0);
        }
        return Math.sqrt(distance);
    }

    public double distanceToClosedPoint(double[] point, double[][] front) {
        double minDistance = this.distance(point, front[0]);
        for (int i = 1; i < front.length; ++i) {
            double aux = this.distance(point, front[i]);
            if (!(aux < minDistance)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public double distanceToNearestPoint(double[] point, double[][] front) {
        double minDistance = Double.MAX_VALUE;
        for (double[] aFront : front) {
            double aux = this.distance(point, aFront);
            if (!(aux < minDistance) || !(aux > 0.0)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public double[][] getNormalizedFront(double[][] front, double[] maximumValue, double[] minimumValue) {
        double[][] normalizedFront = new double[front.length][];
        for (int i = 0; i < front.length; ++i) {
            normalizedFront[i] = new double[front[i].length];
            for (int j = 0; j < front[i].length; ++j) {
                normalizedFront[i][j] = (front[i][j] - minimumValue[j]) / (maximumValue[j] - minimumValue[j]);
            }
        }
        return normalizedFront;
    }

    public double[][] invertedFront(double[][] front) {
        double[][] invertedFront = new double[front.length][];
        for (int i = 0; i < front.length; ++i) {
            invertedFront[i] = new double[front[i].length];
            for (int j = 0; j < front[i].length; ++j) {
                if (front[i][j] <= 1.0 && front[i][j] >= 0.0) {
                    invertedFront[i][j] = 1.0 - front[i][j];
                    continue;
                }
                if (front[i][j] > 1.0) {
                    invertedFront[i][j] = 0.0;
                    continue;
                }
                if (!(front[i][j] < 0.0)) continue;
                invertedFront[i][j] = 1.0;
            }
        }
        return invertedFront;
    }

    public SolutionSet readSolutionSet(String path) {
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            SolutionSet solutionSet = new SolutionSet();
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int i = 0;
                Solution solution = new Solution(st.countTokens());
                while (st.hasMoreTokens()) {
                    double value = new Double(st.nextToken());
                    solution.setObjective(i, value);
                    ++i;
                }
                solutionSet.setCapacity(solutionSet.getCapacity() + 1);
                solutionSet.add(solution);
                aux = br.readLine();
            }
            br.close();
            return solutionSet;
        }
        catch (Exception e) {
            System.out.println("jmetal.qualityIndicator.util.readNonDominatedSolutionSet: " + path);
            e.printStackTrace();
            return null;
        }
    }

    public SolutionSet readNonDominatedSolutionSet(String path) {
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            NonDominatedSolutionList solutionSet = new NonDominatedSolutionList();
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int i = 0;
                Solution solution = new Solution(st.countTokens());
                while (st.hasMoreTokens()) {
                    double value = new Double(st.nextToken());
                    solution.setObjective(i, value);
                    ++i;
                }
                ((SolutionSet)solutionSet).add(solution);
                aux = br.readLine();
            }
            br.close();
            return solutionSet;
        }
        catch (Exception e) {
            System.out.println("jmetal.qualityIndicator.util.readNonDominatedSolutionSet: " + path);
            e.printStackTrace();
            return null;
        }
    }

    public void readNonDominatedSolutionSet(String path, NonDominatedSolutionList solutionSet) {
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int i = 0;
                Solution solution = new Solution(st.countTokens());
                while (st.hasMoreTokens()) {
                    double value = new Double(st.nextToken());
                    solution.setObjective(i, value);
                    ++i;
                }
                solutionSet.add(solution);
                aux = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("jmetal.qualityIndicator.util.readNonDominatedSolutionSet: " + path);
            e.printStackTrace();
        }
    }

    public double[] hvContributions(int numberOfobjectives, double[][] front) {
        Hypervolume hypervolume = new Hypervolume();
        int numberOfObjectives = numberOfobjectives;
        double[] contributions = new double[front.length];
        double[][] frontSubset = new double[front.length - 1][front[0].length];
        LinkedList<double[]> frontCopy = new LinkedList<double[]>();
        Collections.addAll(frontCopy, front);
        double[][] totalFront = (double[][])frontCopy.toArray((T[])frontSubset);
        double totalVolume = hypervolume.calculateHypervolume(totalFront, totalFront.length, numberOfObjectives);
        for (int i = 0; i < front.length; ++i) {
            double contribution;
            double[] evaluatedPoint = (double[])frontCopy.remove(i);
            frontSubset = (double[][])frontCopy.toArray((T[])frontSubset);
            double hv = hypervolume.calculateHypervolume(frontSubset, frontSubset.length, numberOfObjectives);
            contributions[i] = contribution = totalVolume - hv;
            frontCopy.add(i, evaluatedPoint);
        }
        return contributions;
    }

    public double[] hvContributions(SolutionSet[] populations) {
        boolean empty = true;
        for (SolutionSet population2 : populations) {
            if (population2.size() <= 0) continue;
            empty = false;
        }
        if (empty) {
            int i;
            double[] contributions = new double[populations.length];
            for (i = 0; i < populations.length; ++i) {
                contributions[i] = 0.0;
            }
            for (i = 0; i < populations.length; ++i) {
                System.out.println(contributions[i]);
            }
            return contributions;
        }
        int size = 0;
        double offset_ = 0.0;
        for (SolutionSet population1 : populations) {
            size += population1.size();
        }
        SolutionSet union = new SolutionSet(size);
        for (SolutionSet population : populations) {
            for (int j = 0; j < population.size(); ++j) {
                union.add(population.get(j));
            }
        }
        int numberOfObjectives = union.get(0).getNumberOfObjectives();
        double[][][] frontValues = new double[populations.length + 1][][];
        frontValues[0] = union.writeObjectivesToMatrix();
        for (int i = 0; i < populations.length; ++i) {
            frontValues[i + 1] = populations[i].size() > 0 ? populations[i].writeObjectivesToMatrix() : (double[][])new double[0][];
        }
        double[] maximumValues = this.getMaximumValues(union.writeObjectivesToMatrix(), numberOfObjectives);
        double[] minimumValues = this.getMinimumValues(union.writeObjectivesToMatrix(), numberOfObjectives);
        double[][][] normalizedFront = new double[populations.length + 1][][];
        for (int i = 0; i < normalizedFront.length; ++i) {
            normalizedFront[i] = frontValues[i].length > 0 ? this.getNormalizedFront(frontValues[i], maximumValues, minimumValues) : (double[][])new double[0][];
        }
        double[] offsets = new double[maximumValues.length];
        for (int i = 0; i < maximumValues.length; ++i) {
            offsets[i] = offset_ / (maximumValues[i] - minimumValues[i]);
        }
        double[][][] invertedFront = new double[populations.length + 1][][];
        for (int i = 0; i < invertedFront.length; ++i) {
            invertedFront[i] = normalizedFront[i].length > 0 ? this.invertedFront(normalizedFront[i]) : (double[][])new double[0][];
        }
        double[][][] arr$ = invertedFront;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[][] anInvertedFront;
            for (double[] point : anInvertedFront = arr$[i$]) {
                for (int i = 0; i < point.length; ++i) {
                    int n = i;
                    point[n] = point[n] + offsets[i];
                }
            }
        }
        double[] contribution = new double[populations.length];
        Hypervolume hypervolume = new Hypervolume();
        for (int i = 0; i < populations.length; ++i) {
            if (invertedFront[i + 1].length == 0) {
                contribution[i] = 0.0;
                continue;
            }
            if (invertedFront[i + 1].length != invertedFront[0].length) {
                double[][] aux = new double[invertedFront[0].length - invertedFront[i + 1].length][];
                int startPoint = 0;
                for (int j = 0; j < i; ++j) {
                    startPoint += invertedFront[j + 1].length;
                }
                int endPoint = startPoint + invertedFront[i + 1].length;
                int index = 0;
                for (int j = 0; j < invertedFront[0].length; ++j) {
                    if (j >= startPoint && j < endPoint) continue;
                    aux[index++] = invertedFront[0][j];
                }
                contribution[i] = hypervolume.calculateHypervolume(invertedFront[0], invertedFront[0].length, numberOfObjectives) - hypervolume.calculateHypervolume(aux, aux.length, numberOfObjectives);
                continue;
            }
            contribution[i] = hypervolume.calculateHypervolume(invertedFront[0], invertedFront[0].length, numberOfObjectives);
        }
        return contribution;
    }

    public double[] hvContributions(SolutionSet archive, SolutionSet[] populations) {
        int size = 0;
        double offset_ = 0.0;
        for (SolutionSet population : populations) {
            size += population.size();
        }
        SolutionSet union = archive;
        int numberOfObjectives = union.get(0).getNumberOfObjectives();
        double[][][] frontValues = new double[populations.length + 1][][];
        frontValues[0] = union.writeObjectivesToMatrix();
        for (int i = 0; i < populations.length; ++i) {
            frontValues[i + 1] = populations[i].size() > 0 ? populations[i].writeObjectivesToMatrix() : (double[][])new double[0][];
        }
        double[] maximumValues = this.getMaximumValues(union.writeObjectivesToMatrix(), numberOfObjectives);
        double[] minimumValues = this.getMinimumValues(union.writeObjectivesToMatrix(), numberOfObjectives);
        double[][][] normalizedFront = new double[populations.length + 1][][];
        for (int i = 0; i < normalizedFront.length; ++i) {
            normalizedFront[i] = frontValues[i].length > 0 ? this.getNormalizedFront(frontValues[i], maximumValues, minimumValues) : (double[][])new double[0][];
        }
        double[] offsets = new double[maximumValues.length];
        for (int i = 0; i < maximumValues.length; ++i) {
            offsets[i] = offset_ / (maximumValues[i] - minimumValues[i]);
        }
        double[][][] invertedFront = new double[populations.length + 1][][];
        for (int i = 0; i < invertedFront.length; ++i) {
            invertedFront[i] = normalizedFront[i].length > 0 ? this.invertedFront(normalizedFront[i]) : (double[][])new double[0][];
        }
        double[][][] arr$ = invertedFront;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[][] anInvertedFront;
            for (double[] point : anInvertedFront = arr$[i$]) {
                for (int i = 0; i < point.length; ++i) {
                    int n = i;
                    point[n] = point[n] + offsets[i];
                }
            }
        }
        double[] contribution = new double[populations.length];
        Hypervolume hypervolume = new Hypervolume();
        for (int i = 0; i < populations.length; ++i) {
            if (invertedFront[i + 1].length == 0) {
                contribution[i] = 0.0;
                continue;
            }
            int auxSize = 0;
            for (int j = 0; j < populations.length; ++j) {
                if (j == i) continue;
                auxSize += invertedFront[j + 1].length;
            }
            if (size == archive.size()) {
                contribution[i] = hypervolume.calculateHypervolume(invertedFront[0], invertedFront[0].length, numberOfObjectives);
                continue;
            }
            int index = 0;
            double[][] aux = new double[auxSize][];
            for (int j = 0; j < populations.length; ++j) {
                if (j == i) continue;
                for (int k = 0; k < populations[j].size(); ++k) {
                    aux[index++] = invertedFront[j + 1][k];
                }
            }
            contribution[i] = hypervolume.calculateHypervolume(invertedFront[0], invertedFront[0].length, numberOfObjectives) - hypervolume.calculateHypervolume(aux, aux.length, numberOfObjectives);
        }
        return contribution;
    }
}

