/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.encodings.variable;

import jmetal.encodings.variable.Real;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RealTest
extends Real {
    Real real_;
    static final double EPSILON = 1.0E-14;

    @Before
    public void setUp() throws Exception {
        this.real_ = new Real(-1.0, 1.0, 0.5);
    }

    @After
    public void tearDown() throws Exception {
        this.real_ = null;
    }

    @Test
    public void testGetValue() throws Exception {
        Assert.assertEquals((String)"RealTest", (double)0.5, (double)this.real_.getValue(), (double)1.0E-14);
    }

    @Test
    public void testSetValue() throws Exception {
        double oldValue = this.real_.getValue();
        this.real_.setValue(0.5);
        Assert.assertEquals((String)"RealTest", (double)oldValue, (double)this.real_.getValue(), (double)1.0E-14);
    }

    @Test
    public void testDeepCopy() throws Exception {
        Real real = (Real)this.real_.deepCopy();
        Assert.assertEquals((String)"RealTest", (String)real.toString(), (String)this.real_.toString());
    }

    @Test
    public void testGetLowerBound() throws Exception {
        Assert.assertEquals((String)"RealTest", (double)-1.0, (double)this.real_.getLowerBound(), (double)1.0E-14);
    }

    @Test
    public void testGetUpperBound() throws Exception {
        Assert.assertEquals((String)"RealTest", (double)1.0, (double)this.real_.getUpperBound(), (double)1.0E-14);
    }

    @Test
    public void testSetLowerBound() throws Exception {
        double oldValue = this.real_.getValue();
        this.real_.setLowerBound(0.1);
        Assert.assertEquals((String)"RealTest", (double)0.1, (double)this.real_.getLowerBound(), (double)1.0E-14);
    }

    @Test
    public void testSetUpperBound() throws Exception {
        double oldValue = this.real_.getValue();
        this.real_.setUpperBound(2.0);
        Assert.assertEquals((String)"RealTest", (double)2.0, (double)this.real_.getUpperBound(), (double)1.0E-14);
    }
}

