/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.AbYSS_Settings;
import jmetal.operators.crossover.SBXCrossover;
import jmetal.operators.localSearch.MutationLocalSearch;
import jmetal.operators.mutation.PolynomialMutation;
import jmetal.problems.Fonseca;
import jmetal.util.JMException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbYSS_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/AbYSS.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testSettings() throws JMException {
        double epsilon = 1.0E-15;
        AbYSS_Settings abyssSettings = new AbYSS_Settings("Fonseca");
        Algorithm algorithm = ((Settings)abyssSettings).configure();
        Fonseca problem = new Fonseca("Real");
        SBXCrossover crossover = (SBXCrossover)algorithm.getOperator("crossover");
        double pc = (Double)crossover.getParameter("probability");
        double dic = (Double)crossover.getParameter("distributionIndex");
        MutationLocalSearch improvement = (MutationLocalSearch)algorithm.getOperator("improvement");
        int improvementRounds = (Integer)improvement.getParameter("improvementRounds");
        PolynomialMutation mutation = (PolynomialMutation)improvement.getParameter("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)20L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)10L, (long)((Integer)algorithm.getInputParameter("refSet1Size")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)10L, (long)((Integer)algorithm.getInputParameter("refSet2Size")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)1.0, (double)pc, (double)epsilon);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)20.0, (double)dic, (double)epsilon);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)1L, (long)improvementRounds);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
    }

    @Test
    public void testSettings2() throws JMException {
        double epsilon = 1.0E-15;
        AbYSS_Settings abyssSettings = new AbYSS_Settings("Fonseca");
        Algorithm algorithm = ((Settings)abyssSettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        SBXCrossover crossover = (SBXCrossover)algorithm.getOperator("crossover");
        double pc = (Double)crossover.getParameter("probability");
        double dic = (Double)crossover.getParameter("distributionIndex");
        MutationLocalSearch improvement = (MutationLocalSearch)algorithm.getOperator("improvement");
        int improvementRounds = (Integer)improvement.getParameter("improvementRounds");
        PolynomialMutation mutation = (PolynomialMutation)improvement.getParameter("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)20L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)10L, (long)((Integer)algorithm.getInputParameter("refSet1Size")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)10L, (long)((Integer)algorithm.getInputParameter("refSet2Size")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)1.0, (double)pc, (double)epsilon);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)20.0, (double)dic, (double)epsilon);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (long)1L, (long)improvementRounds);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"AbYSS_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
    }
}

