/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.CellDE_Settings;
import jmetal.operators.crossover.DifferentialEvolutionCrossover;
import jmetal.problems.Fonseca;
import jmetal.util.JMException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CellDE_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/CellDE.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testSettings() throws JMException {
        double epsilon = 1.0E-15;
        CellDE_Settings cellDESettings = new CellDE_Settings("Fonseca");
        Algorithm algorithm = ((Settings)cellDESettings).configure();
        Fonseca problem = new Fonseca("Real");
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)20L, (long)((Integer)algorithm.getInputParameter("archiveFeedBack")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (double)0.5, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"CellDE_SettingsTest", (double)0.5, (double)F, (double)epsilon);
    }

    @Test
    public void testSettings2() throws JMException {
        double epsilon = 1.0E-15;
        CellDE_Settings cellDESettings = new CellDE_Settings("Fonseca");
        Algorithm algorithm = ((Settings)cellDESettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (long)20L, (long)((Integer)algorithm.getInputParameter("archiveFeedBack")).intValue());
        Assert.assertEquals((String)"CellDE_SettingsTest", (double)0.5, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"CellDE_SettingsTest", (double)0.5, (double)F, (double)epsilon);
    }
}

