/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.GDE3_Settings;
import jmetal.operators.crossover.DifferentialEvolutionCrossover;
import jmetal.problems.Fonseca;
import jmetal.util.JMException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class GDE3_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/GDE3.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void test() throws JMException {
        double epsilon = 1.0E-15;
        GDE3_Settings GDE3Settings = new GDE3_Settings("Fonseca");
        Algorithm algorithm = ((Settings)GDE3Settings).configure();
        Fonseca problem = new Fonseca("Real");
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"GDE3_SettingsTest", (int)100, (int)((Integer)algorithm.getInputParameter("populationSize")));
        Assert.assertEquals((String)"GDE3_SettingsTest", (int)250, (int)((Integer)algorithm.getInputParameter("maxIterations")));
        Assert.assertEquals((String)"GDE3_SettingsTest", (double)0.5, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"GDE3_SettingsTest", (double)0.5, (double)F, (double)epsilon);
    }

    @Test
    public void test2() throws JMException {
        double epsilon = 1.0E-15;
        GDE3_Settings GDE3Settings = new GDE3_Settings("Fonseca");
        Algorithm algorithm = ((Settings)GDE3Settings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"GDE3_SettingsTest", (int)100, (int)((Integer)algorithm.getInputParameter("populationSize")));
        Assert.assertEquals((String)"GDE3_SettingsTest", (int)250, (int)((Integer)algorithm.getInputParameter("maxIterations")));
        Assert.assertEquals((String)"GDE3_SettingsTest", (double)0.5, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"GDE3_SettingsTest", (double)0.5, (double)F, (double)epsilon);
    }
}

