/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.MOCHC_Settings;
import jmetal.operators.crossover.HUXCrossover;
import jmetal.operators.mutation.BitFlipMutation;
import jmetal.operators.selection.RankingAndCrowdingSelection;
import jmetal.problems.ZDT.ZDT5;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MOCHC_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/MOCHC.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testConfigure() throws Exception {
        double epsilon = 1.0E-15;
        MOCHC_Settings mochcSettings = new MOCHC_Settings("ZDT5");
        Algorithm algorithm = ((Settings)mochcSettings).configure();
        ZDT5 problem = new ZDT5("Binary");
        HUXCrossover crossover = (HUXCrossover)algorithm.getOperator("crossover");
        double pc = (Double)crossover.getParameter("probability");
        RankingAndCrowdingSelection rankingAndCrowdingSelection = (RankingAndCrowdingSelection)algorithm.getOperator("newGenerationSelection");
        Problem problem2 = (Problem)rankingAndCrowdingSelection.getParameter("problem");
        BitFlipMutation mutation = (BitFlipMutation)algorithm.getOperator("cataclysmicMutation");
        double pm = (Double)mutation.getParameter("probability");
        Assert.assertEquals((String)"MOCHC_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"MOCHC_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)0.25, (double)((Double)algorithm.getInputParameter("initialConvergenceCount")), (double)epsilon);
        Assert.assertEquals((String)"MOCHC_SettingsTest", (long)3L, (long)((Integer)algorithm.getInputParameter("convergenceValue")).intValue());
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)0.05, (double)((Double)algorithm.getInputParameter("preservedPopulation")), (double)epsilon);
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)1.0, (double)pc, (double)epsilon);
        Assert.assertTrue((String)"MOCHC_SettingsTest", (boolean)problem.getName().equals("ZDT5"));
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)0.35, (double)pm, (double)epsilon);
    }

    @Test
    public void testConfigure2() throws Exception {
        double epsilon = 1.0E-15;
        MOCHC_Settings mochcSettings = new MOCHC_Settings("ZDT5");
        Algorithm algorithm = ((Settings)mochcSettings).configure(this.configuration_);
        ZDT5 problem = new ZDT5("Binary");
        HUXCrossover crossover = (HUXCrossover)algorithm.getOperator("crossover");
        double pc = (Double)crossover.getParameter("probability");
        RankingAndCrowdingSelection rankingAndCrowdingSelection = (RankingAndCrowdingSelection)algorithm.getOperator("newGenerationSelection");
        Problem problem2 = (Problem)rankingAndCrowdingSelection.getParameter("problem");
        BitFlipMutation mutation = (BitFlipMutation)algorithm.getOperator("cataclysmicMutation");
        double pm = (Double)mutation.getParameter("probability");
        Assert.assertEquals((String)"MOCHC_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"MOCHC_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)0.25, (double)((Double)algorithm.getInputParameter("initialConvergenceCount")), (double)epsilon);
        Assert.assertEquals((String)"MOCHC_SettingsTest", (long)3L, (long)((Integer)algorithm.getInputParameter("convergenceValue")).intValue());
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)0.05, (double)((Double)algorithm.getInputParameter("preservedPopulation")), (double)epsilon);
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)1.0, (double)pc, (double)epsilon);
        Assert.assertTrue((String)"MOCHC_SettingsTest", (boolean)problem.getName().equals("ZDT5"));
        Assert.assertEquals((String)"MOCHC_SettingsTest", (double)0.35, (double)pm, (double)epsilon);
    }
}

