/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.MOEAD_DRA_Settings;
import jmetal.operators.crossover.DifferentialEvolutionCrossover;
import jmetal.operators.mutation.PolynomialMutation;
import jmetal.problems.Fonseca;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class MOEAD_DRA_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/MOEAD_DRA.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testConfigure() throws Exception {
        double epsilon = 1.0E-15;
        MOEAD_DRA_Settings MOEAD_DRASettings = new MOEAD_DRA_Settings("Fonseca");
        Algorithm algorithm = ((Settings)MOEAD_DRASettings).configure();
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        String dataDirectory = (String)algorithm.getInputParameter("dataDirectory");
        System.out.println(dataDirectory);
        File experimentDirectory = new File(dataDirectory);
        int populationSize = (Integer)algorithm.getInputParameter("populationSize");
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)600, (int)populationSize);
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)300000, (int)((Integer)algorithm.getInputParameter("maxEvaluations")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)300, (int)((Integer)algorithm.getInputParameter("finalSize")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)0.9, (double)((Double)algorithm.getInputParameter("delta")), (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)60, (int)((Integer)algorithm.getInputParameter("T")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)6, (int)((Integer)algorithm.getInputParameter("nr")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)1.0, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)0.5, (double)F, (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertTrue((String)"MOEAD_DRASettings", (boolean)experimentDirectory.exists());
    }

    @Test
    public void testConfigure2() throws Exception {
        double epsilon = 1.0E-15;
        MOEAD_DRA_Settings MOEAD_DRASettings = new MOEAD_DRA_Settings("Fonseca");
        Algorithm algorithm = ((Settings)MOEAD_DRASettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        String dataDirectory = (String)algorithm.getInputParameter("dataDirectory");
        System.out.println(dataDirectory);
        File experimentDirectory = new File(dataDirectory);
        int populationSize = (Integer)algorithm.getInputParameter("populationSize");
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)600, (int)populationSize);
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)300000, (int)((Integer)algorithm.getInputParameter("maxEvaluations")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)300, (int)((Integer)algorithm.getInputParameter("finalSize")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)0.9, (double)((Double)algorithm.getInputParameter("delta")), (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)60, (int)((Integer)algorithm.getInputParameter("T")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (int)6, (int)((Integer)algorithm.getInputParameter("nr")));
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)1.0, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)0.5, (double)F, (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"MOEAD_DRASettings", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertTrue((String)"MOEAD_DRASettings", (boolean)experimentDirectory.exists());
    }
}

