/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.NSGAIIBinary_Settings;
import jmetal.operators.crossover.SinglePointCrossover;
import jmetal.operators.mutation.BitFlipMutation;
import jmetal.problems.ZDT.ZDT5;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NSGAIIBinary_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/NSGAIIBinary.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testConfigure() throws Exception {
        double epsilon = 1.0E-15;
        NSGAIIBinary_Settings nsgaIISettings = new NSGAIIBinary_Settings("ZDT5");
        Algorithm algorithm = ((Settings)nsgaIISettings).configure();
        ZDT5 problem = new ZDT5("Binary");
        SinglePointCrossover crossover = (SinglePointCrossover)algorithm.getOperator("crossover");
        double pc = (Double)crossover.getParameter("probability");
        BitFlipMutation mutation = (BitFlipMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (double)0.9, (double)pc, (double)epsilon);
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (double)(1.0 / (double)problem.getNumberOfBits()), (double)pm, (double)epsilon);
    }

    @Test
    public void testConfigure2() throws Exception {
        double epsilon = 1.0E-15;
        NSGAIIBinary_Settings nsgaIISettings = new NSGAIIBinary_Settings("ZDT5");
        Algorithm algorithm = ((Settings)nsgaIISettings).configure(this.configuration_);
        ZDT5 problem = new ZDT5("Binary");
        SinglePointCrossover crossover = (SinglePointCrossover)algorithm.getOperator("crossover");
        double pc = (Double)crossover.getParameter("probability");
        BitFlipMutation mutation = (BitFlipMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("populationSize")).intValue());
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (double)0.9, (double)pc, (double)epsilon);
        Assert.assertEquals((String)"NSGAIIBinary_SettingsTest", (double)(1.0 / (double)problem.getNumberOfBits()), (double)pm, (double)epsilon);
    }
}

