/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.OMOPSO_Settings;
import jmetal.operators.mutation.NonUniformMutation;
import jmetal.operators.mutation.UniformMutation;
import jmetal.problems.Fonseca;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class OMOPSO_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/OMOPSO.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testConfigure() throws Exception {
        double epsilon = 1.0E-15;
        OMOPSO_Settings omopsoSettings = new OMOPSO_Settings("Fonseca");
        Algorithm algorithm = ((Settings)omopsoSettings).configure();
        Fonseca problem = new Fonseca("Real");
        UniformMutation uniformMutation = (UniformMutation)algorithm.getOperator("uniformMutation");
        NonUniformMutation nonUniformMutation = (NonUniformMutation)algorithm.getOperator("nonUniformMutation");
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)100, (int)((Integer)algorithm.getInputParameter("swarmSize")));
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)250, (int)((Integer)algorithm.getInputParameter("maxIterations")));
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)100, (int)((Integer)algorithm.getInputParameter("archiveSize")));
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)((Double)uniformMutation.getParameter("probability")), (double)epsilon);
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (double)0.5, (double)((Double)uniformMutation.getParameter("perturbation")), (double)epsilon);
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)250, (int)((Integer)nonUniformMutation.getParameter("maxIterations")));
    }

    @Test
    public void testConfigure2() throws Exception {
        double epsilon = 1.0E-15;
        OMOPSO_Settings omopsoSettings = new OMOPSO_Settings("Fonseca");
        Algorithm algorithm = ((Settings)omopsoSettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        UniformMutation uniformMutation = (UniformMutation)algorithm.getOperator("uniformMutation");
        NonUniformMutation nonUniformMutation = (NonUniformMutation)algorithm.getOperator("nonUniformMutation");
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)100, (int)((Integer)algorithm.getInputParameter("swarmSize")));
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)250, (int)((Integer)algorithm.getInputParameter("maxIterations")));
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)100, (int)((Integer)algorithm.getInputParameter("archiveSize")));
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)((Double)uniformMutation.getParameter("probability")), (double)epsilon);
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (double)0.5, (double)((Double)uniformMutation.getParameter("perturbation")), (double)epsilon);
        Assert.assertEquals((String)"OMOPSO_SettingsTest", (int)250, (int)((Integer)nonUniformMutation.getParameter("maxIterations")));
    }
}

