/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.PAES_Settings;
import jmetal.operators.mutation.PolynomialMutation;
import jmetal.problems.Fonseca;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PAES_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/PAES.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testConfigure() throws Exception {
        double epsilon = 1.0E-15;
        PAES_Settings paesSettings = new PAES_Settings("Fonseca");
        Algorithm algorithm = ((Settings)paesSettings).configure();
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        Assert.assertEquals((String)"PAES_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"PAES_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"PAES_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertEquals((String)"PAES_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"PAES_SettingsTest", (long)5L, (long)((Integer)algorithm.getInputParameter("biSections")).intValue());
    }

    @Test
    public void testConfigure2() throws Exception {
        double epsilon = 1.0E-15;
        PAES_Settings paesSettings = new PAES_Settings("Fonseca");
        Algorithm algorithm = ((Settings)paesSettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        Assert.assertEquals((String)"PAES_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"PAES_SettingsTest", (long)25000L, (long)((Integer)algorithm.getInputParameter("maxEvaluations")).intValue());
        Assert.assertEquals((String)"PAES_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertEquals((String)"PAES_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"PAES_SettingsTest", (long)5L, (long)((Integer)algorithm.getInputParameter("biSections")).intValue());
    }
}

