/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.SMPSO_Settings;
import jmetal.operators.mutation.PolynomialMutation;
import jmetal.problems.Fonseca;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SMPSO_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/SMPSO.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testConfigure() throws Exception {
        double epsilon = 1.0E-15;
        SMPSO_Settings smpsoSettings = new SMPSO_Settings("Fonseca");
        Algorithm algorithm = ((Settings)smpsoSettings).configure();
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        Assert.assertEquals((String)"SMPSO_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("swarmSize")).intValue());
        Assert.assertEquals((String)"SMPSO_SettingsTest", (long)250L, (long)((Integer)algorithm.getInputParameter("maxIterations")).intValue());
        Assert.assertEquals((String)"SMPSO_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"SMPSO_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertEquals((String)"SMPSO_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
    }

    @Test
    public void testConfigure2() throws Exception {
        double epsilon = 1.0E-15;
        SMPSO_Settings smpsoSettings = new SMPSO_Settings("Fonseca");
        Algorithm algorithm = ((Settings)smpsoSettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        Assert.assertEquals((String)"SMPSO_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("swarmSize")).intValue());
        Assert.assertEquals((String)"SMPSO_SettingsTest", (long)250L, (long)((Integer)algorithm.getInputParameter("maxIterations")).intValue());
        Assert.assertEquals((String)"SMPSO_SettingsTest", (long)100L, (long)((Integer)algorithm.getInputParameter("archiveSize")).intValue());
        Assert.assertEquals((String)"SMPSO_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertEquals((String)"SMPSO_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
    }
}

