/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.experiments.settings;

import experiments.settings.jMetalHome;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.cMOEAD_Settings;
import jmetal.operators.crossover.DifferentialEvolutionCrossover;
import jmetal.operators.mutation.PolynomialMutation;
import jmetal.problems.Fonseca;
import jmetal.util.JMException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class cMOEAD_SettingsTest {
    Properties configuration_;

    @Before
    public void init() throws FileNotFoundException, IOException {
        this.configuration_ = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(jMetalHome.jMetalHomeConfDir + "/cMOEAD.conf"));
        this.configuration_.load(isr);
    }

    @Test
    public void testSettings() throws JMException {
        double epsilon = 1.0E-15;
        cMOEAD_Settings cMOEADSettings = new cMOEAD_Settings("Fonseca");
        Algorithm algorithm = ((Settings)cMOEADSettings).configure();
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        String dataDirectory = (String)algorithm.getInputParameter("dataDirectory");
        System.out.println(dataDirectory);
        File experimentDirectory = new File(dataDirectory);
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)300, (int)((Integer)algorithm.getInputParameter("populationSize")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)150000, (int)((Integer)algorithm.getInputParameter("maxEvaluations")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)0.9, (double)((Double)algorithm.getInputParameter("delta")), (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)20, (int)((Integer)algorithm.getInputParameter("T")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)2, (int)((Integer)algorithm.getInputParameter("nr")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)1.0, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)0.5, (double)F, (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertTrue((String)"cMOEAD_SettingsTest", (boolean)experimentDirectory.exists());
    }

    @Test
    public void testSettings2() throws JMException {
        double epsilon = 1.0E-15;
        cMOEAD_Settings cMOEADSettings = new cMOEAD_Settings("Fonseca");
        Algorithm algorithm = ((Settings)cMOEADSettings).configure(this.configuration_);
        Fonseca problem = new Fonseca("Real");
        PolynomialMutation mutation = (PolynomialMutation)algorithm.getOperator("mutation");
        double pm = (Double)mutation.getParameter("probability");
        double dim = (Double)mutation.getParameter("distributionIndex");
        String dataDirectory = (String)algorithm.getInputParameter("dataDirectory");
        System.out.println(dataDirectory);
        File experimentDirectory = new File(dataDirectory);
        DifferentialEvolutionCrossover crossover = (DifferentialEvolutionCrossover)algorithm.getOperator("crossover");
        double CR = (Double)crossover.getParameter("CR");
        double F = (Double)crossover.getParameter("F");
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)300, (int)((Integer)algorithm.getInputParameter("populationSize")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)150000, (int)((Integer)algorithm.getInputParameter("maxEvaluations")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)0.9, (double)((Double)algorithm.getInputParameter("delta")), (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)20, (int)((Integer)algorithm.getInputParameter("T")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (int)2, (int)((Integer)algorithm.getInputParameter("nr")));
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)1.0, (double)CR, (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)0.5, (double)F, (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)20.0, (double)dim, (double)epsilon);
        Assert.assertEquals((String)"cMOEAD_SettingsTest", (double)(1.0 / (double)problem.getNumberOfVariables()), (double)pm, (double)epsilon);
        Assert.assertTrue((String)"cMOEAD_SettingsTest", (boolean)experimentDirectory.exists());
    }
}

