/*
 * Decompiled with CFR 0.152.
 */
package jmetal.test.util.avl;

import java.util.Comparator;
import jmetal.util.avl.AvlNode;
import jmetal.util.avl.AvlTree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvlTreeTest {
    AvlTree<Integer> avlTree_;
    Comparator comparator_;

    @Before
    public void setUp() throws Exception {
        this.comparator_ = new Comparator(){

            public int compare(Object o1, Object o2) {
                if ((Integer)o1 < (Integer)o2) {
                    return -1;
                }
                if ((Integer)o1 > (Integer)o2) {
                    return 1;
                }
                return 0;
            }
        };
        this.avlTree_ = new AvlTree(this.comparator_);
    }

    @After
    public void tearDown() throws Exception {
        this.avlTree_ = null;
        this.comparator_ = null;
    }

    @Test
    public void testAvlIsEmpty() throws Exception {
        Assert.assertTrue((String)"TestAvlIsEmpty", (boolean)this.avlTree_.AvlIsEmpty());
        this.avlTree_.insertTop(new AvlNode<Integer>(5));
        Assert.assertFalse((String)"TestAvlIsEmpty", (boolean)this.avlTree_.AvlIsEmpty());
    }

    @Test
    public void testInsertTop() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(4);
        this.avlTree_.insertTop(node);
        junit.framework.Assert.assertEquals((String)"TestInsertTop", node, this.avlTree_.getTop());
        String tree = " | 4";
        junit.framework.Assert.assertEquals((String)"TestInsertTop", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testCompareNodes() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(4);
        AvlNode<Integer> node2 = new AvlNode<Integer>(5);
        AvlNode<Integer> node3 = new AvlNode<Integer>(5);
        junit.framework.Assert.assertEquals((String)"testCompareNodes", (int)-1, (int)this.avlTree_.compareNodes(node1, node2));
        junit.framework.Assert.assertEquals((String)"testCompareNodes", (int)1, (int)this.avlTree_.compareNodes(node3, node1));
        junit.framework.Assert.assertEquals((String)"testCompareNodes", (int)0, (int)this.avlTree_.compareNodes(node2, node3));
    }

    @Test
    public void testInsertingRightAndLeftElementsJustAfterTop() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(6);
        this.avlTree_.insertAvlNode(node);
        AvlNode<Integer> nodeLeft = new AvlNode<Integer>(4);
        AvlNode<Integer> nodeRight = new AvlNode<Integer>(9);
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", (int)-1, (int)this.avlTree_.searchClosestNode(nodeLeft));
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", node, nodeLeft.getClosestNode());
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", (int)1, (int)this.avlTree_.searchClosestNode(nodeRight));
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", node, nodeRight.getClosestNode());
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", (int)0, (int)this.avlTree_.searchClosestNode(node));
        node.setLeft(nodeLeft);
        node.setRight(nodeRight);
        AvlNode<Integer> nodeRightLeft = new AvlNode<Integer>(7);
        this.avlTree_.searchClosestNode(nodeRightLeft);
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", (int)-1, (int)this.avlTree_.searchClosestNode(nodeRightLeft));
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", nodeRight, nodeRightLeft.getClosestNode());
        AvlNode<Integer> nodeLeftRight = new AvlNode<Integer>(5);
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", (int)1, (int)this.avlTree_.searchClosestNode(nodeLeftRight));
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", nodeLeft, nodeLeftRight.getClosestNode());
        String tree = " | 6 | 4 | 9";
        junit.framework.Assert.assertEquals((String)"testInsertingSecondSmallerElement", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInsertingLeftElement() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(6);
        this.avlTree_.insertAvlNode(node);
        AvlNode<Integer> nodeLeft = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(nodeLeft);
        junit.framework.Assert.assertEquals((String)"testInsertingLeftElement", node, (Object)nodeLeft.getParent());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftElement", nodeLeft, (Object)node.getLeft());
        String tree = " | 6 | 4";
        junit.framework.Assert.assertEquals((String)"testInsertingLeftElement", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testSearchClosestNode() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(7);
        int result = this.avlTree_.searchClosestNode(node);
        junit.framework.Assert.assertEquals((String)"testSearchClosestNode", (int)0, (int)result);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(4);
        result = this.avlTree_.searchClosestNode(node);
        junit.framework.Assert.assertEquals((String)"testSearchClosestNode", (int)-1, (int)result);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(9);
        result = this.avlTree_.searchClosestNode(node);
        junit.framework.Assert.assertEquals((String)"testSearchClosestNode", (int)1, (int)result);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(6);
        result = this.avlTree_.searchClosestNode(node);
        junit.framework.Assert.assertEquals((String)"testSearchClosestNode", (int)1, (int)result);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(8);
        result = this.avlTree_.searchClosestNode(node);
        junit.framework.Assert.assertEquals((String)"testSearchClosestNode", (int)-1, (int)result);
        this.avlTree_.insertAvlNode(node);
        String tree = " | 7 | 4 | 6 | 9 | 8";
        junit.framework.Assert.assertEquals((String)"testSearchClosestNode", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInsertingRightElement() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(6);
        this.avlTree_.insertAvlNode(node);
        AvlNode<Integer> nodeRight = new AvlNode<Integer>(9);
        this.avlTree_.insertAvlNode(nodeRight);
        junit.framework.Assert.assertEquals((String)"testInsertingRightElement", node, (Object)nodeRight.getParent());
        junit.framework.Assert.assertEquals((String)"testInsertingRightElement", nodeRight, (Object)node.getRight());
        String tree = " | 6 | 9";
        junit.framework.Assert.assertEquals((String)"testInsertingRightElement", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testHeightAndBalanceOfASimpleBalancedTree() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node1));
        AvlNode<Integer> node2 = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(node2);
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)1, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)-1, (int)this.avlTree_.getBalance(node1));
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node2));
        AvlNode<Integer> node3 = new AvlNode<Integer>(9);
        this.avlTree_.insertAvlNode(node3);
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)node3.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)1, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node1));
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node3));
        AvlNode<Integer> node4 = new AvlNode<Integer>(3);
        this.avlTree_.insertAvlNode(node4);
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)node4.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)1, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)2, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)-1, (int)this.avlTree_.getBalance(node2));
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)-1, (int)this.avlTree_.getBalance(node1));
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node4));
        AvlNode<Integer> node5 = new AvlNode<Integer>(5);
        this.avlTree_.insertAvlNode(node5);
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)node5.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)1, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)2, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node2));
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)-1, (int)this.avlTree_.getBalance(node1));
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (int)0, (int)this.avlTree_.getBalance(node5));
        String tree = " | 7 | 4 | 3 | 5 | 9";
        junit.framework.Assert.assertEquals((String)"testHeightOfASimpleBalancedTree", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInsertingLeftLeftNodeAndRebalance() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)0, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)0, (int)this.avlTree_.getBalance(node1));
        AvlNode<Integer> node2 = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(node2);
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)0, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)1, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.getBalance(node1));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)0, (int)this.avlTree_.getBalance(node2));
        AvlNode<Integer> node3 = new AvlNode<Integer>(3);
        this.avlTree_.insertAvlNode(node3);
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", node2, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", node3, (Object)node2.getLeft());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", node1, (Object)node2.getRight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)1, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getLeft().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getRight().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getRight()));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node3.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node3.getRight()));
        String tree = " | 4 | 3 | 7";
        junit.framework.Assert.assertEquals((String)"testInsertingLeftLeftNodeAndRebalance", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInsertingRightRightNodeAndRebalance() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)0, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)0, (int)this.avlTree_.getBalance(node1));
        AvlNode<Integer> node2 = new AvlNode<Integer>(10);
        this.avlTree_.insertAvlNode(node2);
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)0, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)1, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)1, (int)this.avlTree_.getBalance(node1));
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)0, (int)this.avlTree_.getBalance(node2));
        AvlNode<Integer> node3 = new AvlNode<Integer>(14);
        this.avlTree_.insertAvlNode(node3);
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", node2, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", node1, (Object)node2.getLeft());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", node3, (Object)node2.getRight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)1, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getLeft().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getRight().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getRight()));
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node3.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node3.getRight()));
        String tree = " | 10 | 7 | 14";
        junit.framework.Assert.assertEquals((String)"testInsertingRightRightNodeAndRebalance", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInserting7_4_3_2_1() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        AvlNode<Integer> node2 = new AvlNode<Integer>(4);
        AvlNode<Integer> node3 = new AvlNode<Integer>(3);
        AvlNode<Integer> node4 = new AvlNode<Integer>(2);
        AvlNode<Integer> node5 = new AvlNode<Integer>(1);
        this.avlTree_.insertAvlNode(node1);
        this.avlTree_.insertAvlNode(node2);
        this.avlTree_.insertAvlNode(node3);
        this.avlTree_.insertAvlNode(node4);
        this.avlTree_.insertAvlNode(node5);
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", node2, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", node4, (Object)node2.getLeft());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", node1, (Object)node2.getRight());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", node5, (Object)node4.getLeft());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", node3, (Object)node4.getRight());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", (int)0, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", (int)2, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", (int)1, (int)node4.getHeight());
        String tree = " | 4 | 2 | 1 | 3 | 7";
        junit.framework.Assert.assertEquals((String)"testInserting7_4_3_2_1", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInserting7_8_9_10_11() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        AvlNode<Integer> node2 = new AvlNode<Integer>(8);
        AvlNode<Integer> node3 = new AvlNode<Integer>(9);
        AvlNode<Integer> node4 = new AvlNode<Integer>(10);
        AvlNode<Integer> node5 = new AvlNode<Integer>(11);
        this.avlTree_.insertAvlNode(node1);
        this.avlTree_.insertAvlNode(node2);
        this.avlTree_.insertAvlNode(node3);
        this.avlTree_.insertAvlNode(node4);
        this.avlTree_.insertAvlNode(node5);
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", node2, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", node4, (Object)node2.getRight());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", node1, (Object)node2.getLeft());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", node5, (Object)node4.getRight());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", node3, (Object)node4.getLeft());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", (int)2, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", (int)1, (int)node4.getHeight());
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", (int)0, (int)node1.getHeight());
        String tree = " | 8 | 7 | 10 | 9 | 11";
        junit.framework.Assert.assertEquals((String)"testInserting7_8_9_10_11", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInsertingLeftRightNodeAndRebalance() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        AvlNode<Integer> node2 = new AvlNode<Integer>(2);
        this.avlTree_.insertAvlNode(node2);
        AvlNode<Integer> node3 = new AvlNode<Integer>(3);
        this.avlTree_.insertAvlNode(node3);
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", node3, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", node2, (Object)node3.getLeft());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", node1, (Object)node3.getRight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)1, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getLeft().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getRight().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node2.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node2.getRight()));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getRight()));
        String tree = " | 3 | 2 | 7";
        junit.framework.Assert.assertEquals((String)"testInsertingLeftRightNodeAndRebalance", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testInsertingRightLeftNodeAndRebalance() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        AvlNode<Integer> node2 = new AvlNode<Integer>(9);
        this.avlTree_.insertAvlNode(node2);
        AvlNode<Integer> node3 = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node3);
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", node3, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", node1, (Object)node3.getLeft());
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", node2, (Object)node3.getRight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)1, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getLeft().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)0, (int)this.avlTree_.getTop().getRight().getHeight());
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node2.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node2.getRight()));
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getLeft()));
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (int)-1, (int)this.avlTree_.height(node1.getRight()));
        String tree = " | 8 | 7 | 9";
        junit.framework.Assert.assertEquals((String)"testInsertingRightLeftNodeAndRebalance", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testSearchNode() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        AvlNode<Integer> node2 = new AvlNode<Integer>(9);
        this.avlTree_.insertAvlNode(node2);
        AvlNode<Integer> node3 = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node3);
        AvlNode<Integer> node4 = new AvlNode<Integer>(2);
        this.avlTree_.insertAvlNode(node4);
        AvlNode<Integer> node5 = new AvlNode<Integer>(3);
        this.avlTree_.insertAvlNode(node5);
        junit.framework.Assert.assertEquals((String)"testSearchNode", node1, this.avlTree_.search(7));
        junit.framework.Assert.assertEquals((String)"testSearchNode", node2, this.avlTree_.search(9));
        junit.framework.Assert.assertEquals((String)"testSearchNode", node3, this.avlTree_.search(8));
        junit.framework.Assert.assertEquals((String)"testSearchNode", (Object)2, (Object)this.avlTree_.searchNode(new AvlNode<Integer>(2)).getItem());
        junit.framework.Assert.assertEquals((String)"testSearchNode", node4, this.avlTree_.search(2));
        junit.framework.Assert.assertEquals((String)"testSearchNode", node5, this.avlTree_.search(3));
        junit.framework.Assert.assertNull((String)"testInsertNode", this.avlTree_.search(14));
        junit.framework.Assert.assertNull((String)"testSearchNode", this.avlTree_.search(0));
        String tree = " | 8 | 3 | 2 | 7 | 9";
        junit.framework.Assert.assertEquals((String)"testSearchNode", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testFindSuccessor() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(20);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(22);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(12);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(24);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(10);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(14);
        this.avlTree_.insertAvlNode(node);
        node = this.avlTree_.search(8);
        junit.framework.Assert.assertEquals((String)"testFindSuccessor", this.avlTree_.search(10), this.avlTree_.findSuccessor(node));
        node = this.avlTree_.search(10);
        junit.framework.Assert.assertEquals((String)"testFindSuccessor", this.avlTree_.search(12), this.avlTree_.findSuccessor(node));
        node = this.avlTree_.search(14);
        junit.framework.Assert.assertEquals((String)"testFindSuccessor", this.avlTree_.search(20), this.avlTree_.findSuccessor(node));
        String tree = " | 20 | 8 | 4 | 12 | 10 | 14 | 22 | 24";
        junit.framework.Assert.assertEquals((String)"testSearchNode", (String)tree, (String)this.avlTree_.toString());
    }

    @Test
    public void testDeletingLeafNodes() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        AvlNode<Integer> node2 = new AvlNode<Integer>(9);
        this.avlTree_.insertAvlNode(node2);
        AvlNode<Integer> node3 = new AvlNode<Integer>(2);
        this.avlTree_.insertAvlNode(node3);
        AvlNode<Integer> node4 = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node4);
        AvlNode<Integer> node5 = new AvlNode<Integer>(3);
        this.avlTree_.insertAvlNode(node5);
        String tree = " | 7 | 2 | 3 | 9 | 8";
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (String)tree, (String)this.avlTree_.toString());
        this.avlTree_.delete(3);
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", null, (Object)node3.getRight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (int)0, (int)node3.getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (int)2, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (String)" | 7 | 2 | 9 | 8", (String)this.avlTree_.toString());
        this.avlTree_.delete(8);
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", null, (Object)node2.getLeft());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (int)0, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (int)1, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (String)" | 7 | 2 | 9", (String)this.avlTree_.toString());
        this.avlTree_.delete(2);
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", null, (Object)node1.getLeft());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (int)1, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (String)" | 7 | 9", (String)this.avlTree_.toString());
        this.avlTree_.delete(9);
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", null, (Object)node1.getRight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (int)0, (int)node1.getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (String)" | 7", (String)this.avlTree_.toString());
        this.avlTree_.delete(7);
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", null, this.avlTree_.getTop());
        junit.framework.Assert.assertEquals((String)"testDeletingLeafNodes", (String)"", (String)this.avlTree_.toString());
    }

    @Test
    public void testDeletingNodesWithOneLeaf() throws Exception {
        AvlNode<Integer> node1 = new AvlNode<Integer>(7);
        this.avlTree_.insertAvlNode(node1);
        AvlNode<Integer> node2 = new AvlNode<Integer>(9);
        this.avlTree_.insertAvlNode(node2);
        AvlNode<Integer> node3 = new AvlNode<Integer>(2);
        this.avlTree_.insertAvlNode(node3);
        AvlNode<Integer> node4 = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node4);
        AvlNode<Integer> node5 = new AvlNode<Integer>(3);
        this.avlTree_.insertAvlNode(node5);
        String tree = " | 7 | 2 | 3 | 9 | 8";
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (String)tree, (String)this.avlTree_.toString());
        this.avlTree_.delete(2);
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (Object)node3.getItem(), node1.getLeft().getItem());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", null, (Object)node3.getRight());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (int)0, (int)node3.getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (int)2, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (String)" | 7 | 3 | 9 | 8", (String)this.avlTree_.toString());
        this.avlTree_.delete(9);
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (Object)node2.getItem(), node1.getRight().getItem());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", null, (Object)node2.getLeft());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (int)0, (int)node2.getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (int)1, (int)this.avlTree_.getTop().getHeight());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithOneLeaf", (String)" | 7 | 3 | 8", (String)this.avlTree_.toString());
    }

    @Test
    public void testDeletingNodesWithTwoLeaves() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(20);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(22);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(12);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(24);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(10);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(14);
        this.avlTree_.insertAvlNode(node);
        String expected = " | 20 | 8 | 4 | 12 | 10 | 14 | 22 | 24";
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithTwoLeaves", (String)expected, (String)this.avlTree_.toString());
        this.avlTree_.delete(12);
        node = this.avlTree_.search(8);
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithTwoLeaves", (Object)14, node.getRight().getItem());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithTwoLeaves", (String)" | 20 | 8 | 4 | 14 | 10 | 22 | 24", (String)this.avlTree_.toString());
        this.avlTree_.delete(8);
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithTwoLeaves", (Object)10, this.avlTree_.getTop().getLeft().getItem());
        junit.framework.Assert.assertEquals((String)"testDeletingNodesWithTwoLeaves", (String)" | 20 | 10 | 4 | 14 | 22 | 24", (String)this.avlTree_.toString());
    }

    @Test
    public void testDeletingAndRebalancing() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(20);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(22);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(12);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(24);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(10);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(14);
        this.avlTree_.insertAvlNode(node);
        junit.framework.Assert.assertEquals((String)"testDeletingDeepLeafNode", (int)3, (int)this.avlTree_.getTop().getHeight());
        this.avlTree_.delete(22);
        junit.framework.Assert.assertEquals((String)"testDeletingDeepLeafNode", (int)12, (int)this.avlTree_.getTop().getItem());
        junit.framework.Assert.assertEquals((String)"testDeletingDeepLeafNode", this.avlTree_.search(8), (Object)this.avlTree_.getTop().getLeft());
        junit.framework.Assert.assertEquals((String)"testDeletingDeepLeafNode", this.avlTree_.search(20), (Object)this.avlTree_.getTop().getRight());
    }

    @Test
    public void testDeletingTopNode() throws Exception {
        AvlNode<Integer> node = new AvlNode<Integer>(20);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(8);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(22);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(4);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(12);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(24);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(10);
        this.avlTree_.insertAvlNode(node);
        node = new AvlNode<Integer>(14);
        this.avlTree_.insertAvlNode(node);
        junit.framework.Assert.assertEquals((String)"testDeletingTopNode", (int)3, (int)this.avlTree_.getTop().getHeight());
        this.avlTree_.delete(20);
        System.out.println(": " + this.avlTree_.toString());
        junit.framework.Assert.assertEquals((String)"testDeletingTopNode", (String)" | 12 | 8 | 4 | 10 | 22 | 14 | 24", (String)this.avlTree_.toString());
    }
}

