/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import jmetal.core.SolutionSet;

public class Neighborhood {
    private static int MAXRADIO = 2;
    private int[][][] structure_;
    private int solutionSetSize_;
    private int rowSize_;

    public Neighborhood(int solutionSetSize) {
        int ind;
        this.solutionSetSize_ = solutionSetSize;
        this.structure_ = new int[this.solutionSetSize_][MAXRADIO][];
        for (ind = 0; ind < this.solutionSetSize_; ++ind) {
            for (int radio = 0; radio < MAXRADIO; ++radio) {
                if (radio == 0) {
                    this.structure_[ind][radio] = new int[8];
                    continue;
                }
                if (radio != 1) continue;
                this.structure_[ind][radio] = new int[24];
            }
        }
        this.rowSize_ = (int)Math.sqrt(this.solutionSetSize_);
        for (ind = 0; ind < this.solutionSetSize_; ++ind) {
            this.structure_[ind][0][Row.N.ordinal()] = ind > this.rowSize_ - 1 ? ind - this.rowSize_ : (ind - this.rowSize_ + solutionSetSize) % solutionSetSize;
            this.structure_[ind][0][Row.E.ordinal()] = (ind + 1) % this.rowSize_ == 0 ? ind - (this.rowSize_ - 1) : ind + 1;
            this.structure_[ind][0][Row.W.ordinal()] = ind % this.rowSize_ == 0 ? ind + (this.rowSize_ - 1) : ind - 1;
            this.structure_[ind][0][Row.S.ordinal()] = (ind + this.rowSize_) % solutionSetSize;
        }
        for (ind = 0; ind < this.solutionSetSize_; ++ind) {
            this.structure_[ind][0][Row.NE.ordinal()] = this.structure_[this.structure_[ind][0][Row.N.ordinal()]][0][Row.E.ordinal()];
            this.structure_[ind][0][Row.NW.ordinal()] = this.structure_[this.structure_[ind][0][Row.N.ordinal()]][0][Row.W.ordinal()];
            this.structure_[ind][0][Row.SE.ordinal()] = this.structure_[this.structure_[ind][0][Row.S.ordinal()]][0][Row.E.ordinal()];
            this.structure_[ind][0][Row.SW.ordinal()] = this.structure_[this.structure_[ind][0][Row.S.ordinal()]][0][Row.W.ordinal()];
        }
    }

    public SolutionSet getFourNeighbors(SolutionSet solutionSet, int location) {
        SolutionSet neighbors = new SolutionSet(24);
        int index = this.structure_[location][0][Row.N.ordinal()];
        neighbors.add(solutionSet.get(index));
        index = this.structure_[location][0][Row.S.ordinal()];
        neighbors.add(solutionSet.get(index));
        index = this.structure_[location][0][Row.E.ordinal()];
        neighbors.add(solutionSet.get(index));
        index = this.structure_[location][0][Row.W.ordinal()];
        neighbors.add(solutionSet.get(index));
        return neighbors;
    }

    public SolutionSet getEightNeighbors(SolutionSet population, int individual) {
        SolutionSet neighbors = new SolutionSet(24);
        int index = this.structure_[individual][0][Row.N.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.S.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.E.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.W.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.NE.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.NW.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.SE.ordinal()];
        neighbors.add(population.get(index));
        index = this.structure_[individual][0][Row.SW.ordinal()];
        neighbors.add(population.get(index));
        return neighbors;
    }

    static enum Row {
        N,
        S,
        E,
        W,
        NW,
        SW,
        NE,
        SE;

    }
}

