/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public abstract class PropUtils {
    public static final char LABEL_RIGHT_DELIMITER = '>';
    public static final char LABEL_LEFT_DELIMITER = '<';

    public static Properties getPropertiesWithPrefix(Properties pro, String prefix) {
        Properties aux = new Properties();
        Enumeration<?> en = pro.propertyNames();
        while (en.hasMoreElements()) {
            String nom = (String)en.nextElement();
            if (!nom.startsWith(prefix)) continue;
            aux.setProperty(nom.substring(prefix.length()), pro.getProperty(nom));
        }
        return aux;
    }

    public static Properties putPrefixToProperties(String prefix, Properties pro) {
        Properties res = new Properties();
        Enumeration<?> en = pro.propertyNames();
        while (en.hasMoreElements()) {
            String nom = (String)en.nextElement();
            res.setProperty(prefix + nom, pro.getProperty(nom));
        }
        return res;
    }

    public static Properties substituteLabels(Properties base, Properties labels) {
        Properties res = new Properties();
        Enumeration<?> en = base.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = base.getProperty(key);
            value.trim();
            if (PropUtils.isLabel(value)) {
                Properties aux = PropUtils.getPropertiesWithPrefix(labels, value);
                aux = PropUtils.putPrefixToProperties(key, aux);
                res.putAll((Map<?, ?>)aux);
                continue;
            }
            res.setProperty(key, value);
        }
        return res;
    }

    public static Properties dereferenceProperties(Properties pro) {
        Properties res = new Properties();
        Enumeration<?> en = pro.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = pro.getProperty(key);
            value.trim();
            if (PropUtils.isLabel(value)) {
                String lab = value.substring(1, value.length() - 1);
                Properties aux = PropUtils.getPropertiesWithPrefix(pro, lab);
                if (aux.isEmpty()) {
                    res.setProperty(key, value);
                } else {
                    aux = PropUtils.putPrefixToProperties(key, aux);
                }
                res.putAll((Map<?, ?>)aux);
                continue;
            }
            res.setProperty(key, value);
        }
        return res;
    }

    public static boolean isLabel(String str) {
        return str.indexOf(60) == 0 && str.indexOf(62) == str.length() - 1;
    }

    public static void main(String[] argv) throws Exception {
        Properties base = new Properties();
        Properties delta = new Properties();
        FileInputStream isbase = new FileInputStream(argv[0]);
        base.load(isbase);
        Properties res = PropUtils.dereferenceProperties(base);
    }

    public static Properties load(String file) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(file);
        properties.load(in);
        in.close();
        return properties;
    }

    public static Properties setDefaultParameters(Properties properties, String algorithmName) {
        Properties parameters = PropUtils.getPropertiesWithPrefix(properties, algorithmName + ".DEFAULT");
        Properties results = PropUtils.getPropertiesWithPrefix(properties, algorithmName + ".DEFAULT");
        for (Object o : parameters.keySet()) {
            String parameter = parameters.getProperty((String)o);
            Properties subParameters = PropUtils.getPropertiesWithPrefix(properties, parameter + ".DEFAULT");
            if (subParameters == null) continue;
            PropUtils.putPrefixToProperties(parameter, subParameters);
            results.putAll((Map<?, ?>)PropUtils.putPrefixToProperties(parameter + ".", subParameters));
        }
        return results;
    }

    public static Properties setDefaultParameters2(Properties properties, String algorithmName) {
        Properties parameters = PropUtils.getPropertiesWithPrefix(properties, algorithmName);
        return parameters;
    }
}

