/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import java.util.Random;
import jmetal.util.IRandomGenerator;

public class RandomGenerator
implements IRandomGenerator {
    double seed;
    double[] oldrand = new double[55];
    int jrand;

    public RandomGenerator() {
        this.seed = new Random(System.nanoTime()).nextDouble();
        this.randomize();
    }

    void randomize() {
        for (int j1 = 0; j1 <= 54; ++j1) {
            this.oldrand[j1] = 0.0;
        }
        this.jrand = 0;
        this.warmup_random(this.seed);
    }

    void warmup_random(double seed) {
        this.oldrand[54] = seed;
        double new_random = 1.0E-9;
        double prev_random = seed;
        for (int j1 = 1; j1 <= 54; ++j1) {
            int ii = 21 * j1 % 54;
            this.oldrand[ii] = new_random;
            if ((new_random = prev_random - new_random) < 0.0) {
                new_random += 1.0;
            }
            prev_random = this.oldrand[ii];
        }
        this.advance_random();
        this.advance_random();
        this.advance_random();
        this.jrand = 0;
    }

    void advance_random() {
        double new_random;
        int j1;
        for (j1 = 0; j1 < 24; ++j1) {
            new_random = this.oldrand[j1] - this.oldrand[j1 + 31];
            if (new_random < 0.0) {
                new_random += 1.0;
            }
            this.oldrand[j1] = new_random;
        }
        for (j1 = 24; j1 < 55; ++j1) {
            new_random = this.oldrand[j1] - this.oldrand[j1 - 24];
            if (new_random < 0.0) {
                new_random += 1.0;
            }
            this.oldrand[j1] = new_random;
        }
    }

    double randomperc() {
        ++this.jrand;
        if (this.jrand >= 55) {
            this.jrand = 1;
            this.advance_random();
        }
        return this.oldrand[this.jrand];
    }

    @Override
    public synchronized int nextInt(int upperBound) {
        return this.rndInt(0, upperBound);
    }

    @Override
    public synchronized double nextDouble() {
        return this.randomperc();
    }

    public synchronized int rndInt(int low, int high) {
        int res;
        if (low >= high) {
            res = low;
        } else {
            res = low + (int)(this.randomperc() * (double)(high - low + 1));
            if (res > high) {
                res = high;
            }
        }
        return res;
    }

    public synchronized double rndReal(double low, double high) {
        return low + (high - low) * this.randomperc();
    }
}

