/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.DistanceNode;
import jmetal.util.DistanceNodeComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.FitnessComparator;

public class Spea2Fitness {
    private double[][] distance = null;
    private SolutionSet solutionSet_ = null;
    private static final Distance distance_ = new Distance();
    private static final Comparator distanceNodeComparator = new DistanceNodeComparator();
    private static final Comparator dominance_ = new DominanceComparator();

    public Spea2Fitness(SolutionSet solutionSet) {
        this.distance = distance_.distanceMatrix(solutionSet);
        this.solutionSet_ = solutionSet;
        for (int i = 0; i < this.solutionSet_.size(); ++i) {
            this.solutionSet_.get(i).setLocation(i);
        }
    }

    public void fitnessAssign() {
        int j;
        int i;
        double[] strength = new double[this.solutionSet_.size()];
        double[] rawFitness = new double[this.solutionSet_.size()];
        for (i = 0; i < this.solutionSet_.size(); ++i) {
            for (j = 0; j < this.solutionSet_.size(); ++j) {
                if (dominance_.compare(this.solutionSet_.get(i), this.solutionSet_.get(j)) != -1) continue;
                int n = i;
                strength[n] = strength[n] + 1.0;
            }
        }
        for (i = 0; i < this.solutionSet_.size(); ++i) {
            for (j = 0; j < this.solutionSet_.size(); ++j) {
                if (dominance_.compare(this.solutionSet_.get(i), this.solutionSet_.get(j)) != 1) continue;
                int n = i;
                rawFitness[n] = rawFitness[n] + strength[j];
            }
        }
        int k = 1;
        for (int i2 = 0; i2 < this.distance.length; ++i2) {
            Arrays.sort(this.distance[i2]);
            double kDistance = 1.0 / (this.distance[i2][k] + 2.0);
            this.solutionSet_.get(i2).setFitness(rawFitness[i2] + kDistance);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public SolutionSet environmentalSelection(int size) {
        if (this.solutionSet_.size() < size) {
            size = this.solutionSet_.size();
        }
        SolutionSet aux = new SolutionSet(this.solutionSet_.size());
        int i = 0;
        while (i < this.solutionSet_.size()) {
            if (this.solutionSet_.get(i).getFitness() < 1.0) {
                aux.add(this.solutionSet_.get(i));
                this.solutionSet_.remove(i);
                continue;
            }
            ++i;
        }
        if (aux.size() < size) {
            FitnessComparator comparator = new FitnessComparator();
            this.solutionSet_.sort(comparator);
            int remain = size - aux.size();
            for (i = 0; i < remain; ++i) {
                aux.add(this.solutionSet_.get(i));
            }
            return aux;
        }
        if (aux.size() == size) {
            return aux;
        }
        double[][] distance = distance_.distanceMatrix(aux);
        LinkedList distanceList = new LinkedList();
        for (int pos = 0; pos < aux.size(); ++pos) {
            aux.get(pos).setLocation(pos);
            ArrayList<DistanceNode> distanceNodeList = new ArrayList<DistanceNode>();
            for (int ref = 0; ref < aux.size(); ++ref) {
                if (pos == ref) continue;
                distanceNodeList.add(new DistanceNode(distance[pos][ref], ref));
            }
            distanceList.add(distanceNodeList);
        }
        for (List aDistanceList : distanceList) {
            Collections.sort(aDistanceList, distanceNodeComparator);
        }
        while (aux.size() > size) {
            double minDistance = Double.MAX_VALUE;
            int toRemove = 0;
            i = 0;
            for (List dn : distanceList) {
                if (((DistanceNode)dn.get(0)).getDistance() < minDistance) {
                    toRemove = i;
                    minDistance = ((DistanceNode)dn.get(0)).getDistance();
                } else if (((DistanceNode)dn.get(0)).getDistance() == minDistance) {
                    int k;
                    for (k = 0; ((DistanceNode)dn.get(k)).getDistance() == ((DistanceNode)((List)distanceList.get(toRemove)).get(k)).getDistance() && k < ((List)distanceList.get(i)).size() - 1; ++k) {
                    }
                    if (((DistanceNode)dn.get(k)).getDistance() < ((DistanceNode)((List)distanceList.get(toRemove)).get(k)).getDistance()) {
                        toRemove = i;
                    }
                }
                ++i;
            }
            int tmp = aux.get(toRemove).getLocation();
            aux.remove(toRemove);
            distanceList.remove(toRemove);
            for (List aDistanceList : distanceList) {
                Iterator interIterator = aDistanceList.iterator();
                while (interIterator.hasNext()) {
                    if (((DistanceNode)interIterator.next()).getReference() != tmp) continue;
                    interIterator.remove();
                }
            }
        }
        return aux;
    }
}

