/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.archive;

import java.util.Comparator;
import java.util.Iterator;
import jmetal.core.Solution;
import jmetal.util.AdaptiveGrid;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.DominanceComparator;

public class AdaptiveGridArchive
extends Archive {
    private AdaptiveGrid grid_;
    private int maxSize_;
    private Comparator dominance_;

    public AdaptiveGridArchive(int maxSize, int bisections, int objectives) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.dominance_ = new DominanceComparator();
        this.grid_ = new AdaptiveGrid(bisections, objectives);
    }

    @Override
    public boolean add(Solution solution) {
        Iterator iterator = this.solutionsList_.iterator();
        while (iterator.hasNext()) {
            Solution element = (Solution)iterator.next();
            int flag = this.dominance_.compare(solution, element);
            if (flag == -1) {
                iterator.remove();
                int location = this.grid_.location(element);
                if (this.grid_.getLocationDensity(location) > 1) {
                    this.grid_.removeSolution(location);
                    continue;
                }
                this.grid_.updateGrid(this);
                continue;
            }
            if (flag != 1) continue;
            return false;
        }
        if (this.size() == 0) {
            this.solutionsList_.add(solution);
            this.grid_.updateGrid(this);
            return true;
        }
        if (this.size() < this.maxSize_) {
            this.grid_.updateGrid(solution, this);
            int location = this.grid_.location(solution);
            this.grid_.addSolution(location);
            this.solutionsList_.add(solution);
            return true;
        }
        this.grid_.updateGrid(solution, this);
        int location = this.grid_.location(solution);
        if (location == this.grid_.getMostPopulated()) {
            return false;
        }
        iterator = this.solutionsList_.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Solution element;
            int location2;
            if (removed || (location2 = this.grid_.location(element = (Solution)iterator.next())) != this.grid_.getMostPopulated()) continue;
            iterator.remove();
            this.grid_.removeSolution(location2);
        }
        this.grid_.addSolution(location);
        this.solutionsList_.add(solution);
        return true;
    }

    public AdaptiveGrid getGrid() {
        return this.grid_;
    }
}

