/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.archive;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.util.Distance;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;

public class CrowdingArchive
extends Archive {
    private int maxSize_;
    private int objectives_;
    private Comparator dominance_;
    private Comparator equals_;
    private Comparator crowdingDistance_;
    private Distance distance_;

    public CrowdingArchive(int maxSize, int numberOfObjectives) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.objectives_ = numberOfObjectives;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.crowdingDistance_ = new CrowdingDistanceComparator();
        this.distance_ = new Distance();
    }

    @Override
    public boolean add(Solution solution) {
        int flag = 0;
        int i = 0;
        while (i < this.solutionsList_.size()) {
            Solution aux = (Solution)this.solutionsList_.get(i);
            flag = this.dominance_.compare(solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionsList_.remove(i);
                continue;
            }
            if (this.equals_.compare(aux, solution) == 0) {
                return false;
            }
            ++i;
        }
        this.solutionsList_.add(solution);
        if (this.size() > this.maxSize_) {
            this.distance_.crowdingDistanceAssignment(this, this.objectives_);
            this.remove(this.indexWorst(this.crowdingDistance_));
        }
        return true;
    }
}

