/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.archive;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.Distance;
import jmetal.util.archive.Archive;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;

public class HypervolumeArchive
extends Archive {
    private int maxSize_;
    private int objectives_;
    private Comparator dominance_;
    private Comparator equals_;
    private Distance distance_;
    private MetricsUtil utils_;
    private double offset_;
    private Comparator crowdingDistance_;

    public HypervolumeArchive(int maxSize, int numberOfObjectives) {
        super(maxSize);
        this.maxSize_ = maxSize;
        this.objectives_ = numberOfObjectives;
        this.dominance_ = new DominanceComparator();
        this.equals_ = new EqualSolutions();
        this.distance_ = new Distance();
        this.utils_ = new MetricsUtil();
        this.offset_ = 100.0;
        this.crowdingDistance_ = new CrowdingDistanceComparator();
    }

    @Override
    public boolean add(Solution solution) {
        int flag = 0;
        int i = 0;
        while (i < this.solutionsList_.size()) {
            Solution aux = (Solution)this.solutionsList_.get(i);
            flag = this.dominance_.compare(solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionsList_.remove(i);
                continue;
            }
            if (this.equals_.compare(aux, solution) == 0) {
                return false;
            }
            ++i;
        }
        this.solutionsList_.add(solution);
        if (this.size() > this.maxSize_) {
            double[][] invertedFront;
            double[][] frontValues = this.writeObjectivesToMatrix();
            int numberOfObjectives = this.objectives_;
            double[] maximumValues = this.utils_.getMaximumValues(this.writeObjectivesToMatrix(), numberOfObjectives);
            double[] minimumValues = this.utils_.getMinimumValues(this.writeObjectivesToMatrix(), numberOfObjectives);
            double[][] normalizedFront = this.utils_.getNormalizedFront(frontValues, maximumValues, minimumValues);
            double[] offsets = new double[maximumValues.length];
            for (i = 0; i < maximumValues.length; ++i) {
                offsets[i] = this.offset_ / (maximumValues[i] - minimumValues[i]);
            }
            for (double[] point : invertedFront = this.utils_.invertedFront(normalizedFront)) {
                for (i = 0; i < point.length; ++i) {
                    int n = i;
                    point[n] = point[n] + offsets[i];
                }
            }
            double[] contributions = this.utils_.hvContributions(this.objectives_, invertedFront);
            for (i = 0; i < contributions.length; ++i) {
                this.get(i).setCrowdingDistance(contributions[i]);
            }
            this.sort(new CrowdingDistanceComparator());
            this.remove(this.size() - 1);
        }
        return true;
    }

    public void actualiseHVContribution() {
        if (this.size() > 2) {
            double[][] invertedFront;
            double[][] frontValues = this.writeObjectivesToMatrix();
            int numberOfObjectives = this.objectives_;
            double[] maximumValues = this.utils_.getMaximumValues(this.writeObjectivesToMatrix(), numberOfObjectives);
            double[] minimumValues = this.utils_.getMinimumValues(this.writeObjectivesToMatrix(), numberOfObjectives);
            double[][] normalizedFront = this.utils_.getNormalizedFront(frontValues, maximumValues, minimumValues);
            double[] offsets = new double[maximumValues.length];
            for (int i = 0; i < maximumValues.length; ++i) {
                offsets[i] = this.offset_ / (maximumValues[i] - minimumValues[i]);
            }
            for (double[] point : invertedFront = this.utils_.invertedFront(normalizedFront)) {
                for (int i = 0; i < point.length; ++i) {
                    int n = i;
                    point[n] = point[n] + offsets[i];
                }
            }
            double[] contributions = this.utils_.hvContributions(this.objectives_, invertedFront);
            for (int i = 0; i < contributions.length; ++i) {
                this.get(i).setCrowdingDistance(contributions[i]);
            }
        }
    }

    public int getLocation(Solution solution) {
        int location = -1;
        for (int index = 0; index < this.size() && location != -1; ++index) {
            if (this.equals_.compare(solution, this.get(index)) != 0) continue;
            location = index;
        }
        return location;
    }
}

